/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     mirror.c                                                       *
 *            mirror images horizontally or/and vertically                   *
 * Autor:     Andreas Tille                                                  *
 * Datum:     30.09.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <stdlib.h>

#include "paul.h" 

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

static void MirrorHorizontally(PICTURE *bild)
/* mirror image horizontally (at a vertical axis)
 * --- Parameter: ---
 * PICTURE *bild : image to mirror
 * --- Return: ---
 * PICTURE *bild : image with mirrored buffer
 */
{
   register unsigned char *ap, *ep;
   unsigned char          *zp, *fzp;
   int                     linesize = bild->storepix * bild->W;
   
   for ( fzp = (zp = bild->DATA) + linesize * bild->H; zp < fzp; zp += linesize )
      for ( ep = (ap = zp) + linesize - 1; ap < ep; ap++, ep-- ) {
         if ( bild->storepix == 1 ) {
	    register unsigned char zw = *ep;
            *ep = *ap;
	    *ap =  zw;
	 } else {
	    register unsigned char zw = *(ep -= 2);
            *ep = *ap;
	    *ap = zw;
            zw  = *++ep;
	    *ep = *++ap;
	    *ap = zw;
            zw  = *++ep;
	    *ep = *++ap;
	    *ap = zw;
            ep -= 2;
	 }
      }
}

static void MirrorVertically(PICTURE *bild)
/* mirror image vertically (at a horizontal axis)
 * --- Parameter: ---
 * PICTURE *bild : image to mirror
 * --- Return: ---
 * PICTURE *bild : image with mirrored buffer
 */
{
   register unsigned char *ap, *ep;
   unsigned char          *buf;
   int                     linesize = bild->storepix * bild->W;
   
   assert ( (buf = malloc(linesize)) );
   
   for ( ep = (ap = bild->DATA) + linesize * (bild->H - 1); ap < ep; ap += linesize, ep -= linesize ) {
      memcpy(buf, ep, linesize);
      memcpy(ep,  ap, linesize);
      memcpy(ap, buf, linesize);
   }
   free(buf);
}


int MakeMirror(PAUL *p)
/* mirror a set of images on vertical (at a horizontal axis) or horizontal (at a vertical axis)
 * --- Parameter: ---
 * PAUL   *p            : list of images
 * --- Return: ---
 * int     MakeMirror() : 0 if OK
 */
{
   PICTURE *bild;
   GList   *pl;

   if ( !NBILDER(p->piclist) ) return 0;

   for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
      if ( HMirror(p->opt->f) ) MirrorHorizontally(bild);
      if ( VMirror(p->opt->f) ) MirrorVertically(bild);
      if ( !Rotate180(p->opt->f) ) {
         CopySpec(bild->spec, ChunkNameTyp, TypMirror);
         NewFileName(bild, APPMIRROR);
         bild->flag |= Mirror(p->opt->f);
      }
   }
   p->opt->f &= ~(MIRROR_H | MIRROR_V);
   return 0;
}

