\ ERRORE.FS English error strings                      9may93jaw

\ Copyright (C) 1995 Free Software Foundation, Inc.

\ This file is part of Gforth.

\ Gforth is free software; you can redistribute it and/or
\ modify it under the terms of the GNU General Public License
\ as published by the Free Software Foundation; either version 2
\ of the License, or (at your option) any later version.

\ This program is distributed in the hope that it will be useful,
\ but WITHOUT ANY WARRANTY; without even the implied warranty of
\ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
\ GNU General Public License for more details.

\ You should have received a copy of the GNU General Public License
\ along with this program; if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


\ The errors are defined by a linked list, for easy adding
\ and deleting. Speed is not neccassary at this point.

AVARIABLE ErrLink              \ Linked list entry point
NIL ErrLink !

decimal

\ error numbers between -256 and -511 represent signals
\ signals are handled with strsignal
\ but some signals produce throw-codes > -256, e.g., -28

\ error numbers between -512 and -2047 are for OS errors and are
\ handled with strerror

: .error ( n -- )
    cr ." Error: "
    ErrLink
    BEGIN @ dup
    WHILE
	2dup cell+ @ =
	IF 2 cells + count type drop exit THEN
    REPEAT
    drop
[ has-os [IF] ]
    dup -511 -255 within
    IF
	256 + negate strsignal type exit
    THEN
    dup -2047 -511 within
    IF
	512 + negate strerror type exit
    THEN
[ [THEN] ]
    . ;

