#!/usr/bin/python

import string

objects = ('GnomeAbout', 'GnomeApp', 'GnomeAppBar', 'GnomeCalculator',
  'GnomeClient', 'GnomeColorPicker', 'GnomeDateEdit',
  'GnomeDEntryEdit', 'GnomeDialog', 'GnomeEntry', 'GnomeFileEntry',
  'GnomeFontSelector', 'GnomeIconList', 'GnomeIconSelection',
  'GnomeLamp', 'GnomeLess', 'GnomeMDI', 'GnomeMDIChild',
  'GnomeMessageBox', 'GnomeNumberEntry', 'GnomePixmap',
  'GnomePropertyBox', 'GnomeRootWin', 'GnomeScores', 'GnomeStock',
  'GtkCalendar', 'GtkClock', 'GtkDial', 'GtkLayout', 'GtkPlug',
  'GtkSocket', 'GtkSpell', 'GtkTed', 'GnomeCanvas', 'GnomeCanvasItem',
  'GnomeCanvasGroup',
	   
  # gtk types:
  'GtkMenuBar', 'GtkToolbar', 'GtkEditable', 'GtkAdjustment',
  'GtkWindow', 'GtkNotebook')

f = open("obj_typemap.i", "w")

f.write("# typemaps for Gnome objects to Python equivalents\n\n");

for obj in objects:
	OBJ = ''
	for c in obj:
		if c in string.uppercase:
			OBJ = OBJ + '_' + c
		else:
			OBJ = OBJ + string.upper(c)
	if OBJ[0] == '_': OBJ = OBJ[1:]
	if obj == 'GnomeRootWin': OBJ = 'GNOME_ROOTWIN'
	if obj == 'GnomeMDI':     OBJ = 'GNOME_MDI'
	if obj == 'GnomeMDIChild':OBJ = 'GNOME_MDI_CHILD'
	if obj == 'GnomeAppBar':  OBJ = 'GNOME_APPBAR'
	if obj == 'GnomeDEntryEdit': OBJ = 'GNOME_DENTRY_EDIT'
	f.write("%%typemap(python,in) %s * {\n" % (obj,))
	f.write("        if (PyGtk_Check($source))\n")
	f.write("            $target = %s(PyGtk_Get($source));\n" % (OBJ,))
	f.write("        else {\n")
	f.write('            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");\n')
	f.write("            return NULL;\n")
	f.write("        }\n")
	f.write("    }\n\n")
	f.write("%%typemap(python,out) %s * {\n" % (obj,))
	f.write("        $target = PyGtk_New((GtkObject *)$source);\n")
	f.write("    }\n\n")

f.close()

