#ifndef MXSTDLIB_H
#define MXSTDLIB_H

/* Standard stuff I use often -- not Python specific */

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include <math.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#else
#define INT_MAX 2147483647
#endif

/* --- My own macros for memory allocation... --------------------------- */

#ifdef MAL_MEM_DEBUG
# define newstruct(x) \
         (mxDebugPrintf("* malloc for struct "#x" (%s:%i)\n",__FILE__,__LINE__),\
	  (x *)malloc(sizeof(x)))
# define cnewstruct(x) \
         (mxDebugPrintf("* calloc for struct "#x" (%s:%i)\n",c,__FILE__,__LINE__),\
	  (x *)calloc(sizeof(x),1))
# define new(x,c) \
         (mxDebugPrintf("* malloc for "#c"=%i '"#x"'s (%s:%i)\n",c,__FILE__,__LINE__),\
	  (x *)malloc(sizeof(x)*(c)))
# define cnew(x,c) \
         (mxDebugPrintf("* calloc for "#c"=%i '"#x"'s (%s:%i)\n",c,__FILE__,__LINE__),\
	  (x *)calloc((c),sizeof(x)))
# define resize(var,x,c) \
         (mxDebugPrintf("* realloc "#x" at %X to size "#c"=%i (%s:%i)\n",x,c,__FILE__,__LINE__),\
	  (x *)realloc((void*)(var),sizeof(x)*(c)))
# define free(x) \
         (mxDebugPrintf("* freeing "#x" at %X (%s:%i)\n",x,__FILE__,__LINE__),\
	  free((void*)(x)))
#else
# define newstruct(x)		(x *)malloc(sizeof(x))
# define cnewstruct(x)		(x *)calloc(sizeof(x),1)
# define new(x,c)		(x *)malloc(sizeof(x)*(c))
# define cnew(x,c)		(x *)calloc((c),sizeof(x))
# define resize(var,x,c)	(x *)realloc((void*)(var),sizeof(x)*(c))
# define free(x) 		free((void*)(x))
#endif

/* --- Debugging output ------------------------------------------------- */

/* File name to be used for debug logging (each object file using this
   facility may set its own logging file): */

#ifndef MAL_DEBUG_OUTPUTFILE
# define MAL_DEBUG_OUTPUTFILE "mxDebugging.log"
#endif

/* Log id to be used; defaults to the name of the logging file */

#ifndef MAL_DEBUG_LOGID
# define MAL_DEBUG_LOGID MAL_DEBUG_OUTPUTFILE
#endif

static
void mxDebugPrintf(const char *format, ...)
{
    va_list args;
    static FILE *mxDebugPrintf_file;

    if (!mxDebugPrintf_file) {
	time_t now;

	if (MAL_DEBUG_OUTPUTFILE == "stdout")
	    mxDebugPrintf_file = stdout;
	else if (MAL_DEBUG_OUTPUTFILE == "stderr")
	    mxDebugPrintf_file = stderr;
	else
	    mxDebugPrintf_file = fopen(MAL_DEBUG_OUTPUTFILE,"ab");
	if (!mxDebugPrintf_file) {
	    /* Hack to shut up "cc -Wall" warning that this function
	       was not used... */
	    static void *mxDebugPrintf_used;
	    mxDebugPrintf_used = (void *)mxDebugPrintf;
	    return;
	}
	now = time(NULL);
	fprintf(mxDebugPrintf_file,
		"\n--- "MAL_DEBUG_LOGID" --- %s\n",
		ctime(&now));
    }

    va_start(args,format);
    vfprintf(mxDebugPrintf_file,format,args);
    fflush(mxDebugPrintf_file);
    va_end(args);
    return;
}

#ifdef MAL_DEBUG
# if defined(PyFloat_AS_DOUBLE) /* check whether we're compiling a Python ext. */
#  define DPRINTF if (Py_DebugFlag) mxDebugPrintf
#  define IF_DEBUGGING if (Py_DebugFlag) 
# else
#  define DPRINTF mxDebugPrintf
#  define IF_DEBUGGING  
# endif
#else
# define DPRINTF if (0) mxDebugPrintf
# define IF_DEBUGGING if (0) 
#endif

/* --- Misc ------------------------------------------------------------- */

/* The usual bunch... */
#ifndef max
#define max(a,b) ((a>b)?(a):(b))
#endif
#ifndef min
#define min(a,b) ((a<b)?(a):(b))
#endif

/* EOF */
#endif

