/*
	Audio File Library

	Copyright 1998, Michael Pruett <michael@68k.org>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the implied
	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
	PURPOSE.  See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
	MA 02111-1307, USA.
*/

/*
	sfconvert.c

	sfconvert is a program which can convert various parameters of
	sound files.

	The real Irix version has a lot of options.  Mine can only
	convert the file format.  I'm working on expanding the
	capabilities of this command.
*/

#ifdef __USE_SGI_HEADERS__
#include <dmedia/audiofile.h>
#else
#include <audiofile.h>
#endif

#include <stdio.h>
#include <stdlib.h>

void usageerror (void);
void printfileinfo (char *filename);

main (int ac, char **av)
{
	int		i = 1;
	char	*infilename, *outfilename;
	int		format;

	int				version;
	AFfilehandle	infile, outfile;
	AFfilesetup		outfilesetup;
	int				sampleFormat, sampleWidth, byteOrder,
	channelCount;
	char			*buffer;

	AFframecount	frameCount;
	int				frameSize;

	if (ac < 3)
		usageerror();

	infilename = av[1];
	outfilename = av[2];

	i = 3;

	while (i < ac)
	{
		if (!strcmp(av[i], "format"))
		{
			if (i + 1 >= ac)
				usageerror();
			if (!strcmp(av[i+1], "aiff"))
				format = AF_FILE_AIFF;
			else if (!strcmp(av[i+1], "aifc"))
				format = AF_FILE_AIFFC;
			else if (!strcmp(av[i+1], "wave"))
				format = AF_FILE_WAVE;
			else if (!strcmp(av[i+1], "next"))
				format = AF_FILE_NEXTSND;

			i++;
		}

		i++;
	}

	infile = afOpenFile(infilename, "r", NULL);

#if defined(__i386__) || defined(__alpha__)
	afSetVirtualByteOrder(infile, AF_DEFAULT_TRACK, AF_BYTEORDER_LITTLEENDIAN);
#else
	afSetVirtualByteOrder(infile, AF_DEFAULT_TRACK, AF_BYTEORDER_BIGENDIAN);
#endif

	frameCount = afGetFrameCount(infile, AF_DEFAULT_TRACK);
	frameSize = afGetFrameSize(infile, AF_DEFAULT_TRACK, 0);
	channelCount = afGetChannels(infile, AF_DEFAULT_TRACK);

	buffer = malloc(frameCount * frameSize);
	afReadFrames(infile, AF_DEFAULT_TRACK, buffer, frameCount);

	afCloseFile(infile);

	outfilesetup = afNewFileSetup();
	afInitFileFormat(outfilesetup, format);
	afInitChannels(outfilesetup, AF_DEFAULT_TRACK, channelCount);
	outfile = afOpenFile(outfilename, "w", outfilesetup);
	afFreeFileSetup(outfilesetup);

#if defined(__i386__) || defined(__alpha__)
	afSetVirtualByteOrder(outfile, AF_DEFAULT_TRACK, AF_BYTEORDER_LITTLEENDIAN);
#else
	afSetVirtualByteOrder(outfile, AF_DEFAULT_TRACK, AF_BYTEORDER_BIGENDIAN);
#endif

	afWriteFrames(outfile, AF_DEFAULT_TRACK, buffer, frameCount);
	afCloseFile(outfile);

	printfileinfo(infilename);
	putchar('\n');
	printfileinfo(outfilename);
}

void usageerror (void)
{
	fprintf(stderr, "usage: sfconvert infile outfile [ options ... ] [ output keywords ... ]\n");
	exit(-1);
}
