// Turning the border on/off by changing the motif_wm_hints property
// works on Irix 4DWM.  Does not appear to work for any other window
// manager.  Fullscreen still works on some window managers (fvwm is one)
// because they allow the border to be placed off-screen.

// Unfortunatly most X window managers ignore changes to the border
// and refuse to position the border off-screen, so attempting to make
// the window full screen will lose the size of the border off the
// bottom and right.

#include <FL/Fl.H>
#include <FL/x.H>

void Fl_Window::border(int b) {
  if (b) {
    if (border()) return;
    set_flag(FL_BORDER);
#ifdef WIN32
  // not yet implemented, but it's possible
#else
    if (shown()) XDeleteProperty(fl_display, i->xid, fl__motif_wm_hints);
#endif
  } else {
    if (!border()) return;
    clear_flag(FL_BORDER);
#ifdef WIN32
  // not yet implemented, but it's possible
  // for full fulscreen we have to make the window topmost as well
#else
    if (shown()) {
      long prop[5]; // see the file /usr/include/X11/Xm/MwmUtil.h
      prop[0] = 3; // MWM_HINTS_FUNCTIONS | MWM_HINTS_DECORATIONS
      prop[1] = 7+16; // MWM_FUNC_ALL | MWM_FUNC_RESIZE | MWM_FUNC_MAXIMIZE
      prop[2] = 0; // no decorations
      XChangeProperty(fl_display, i->xid,
		      fl__motif_wm_hints, fl__motif_wm_hints,
		      32, 0, (unsigned char *)prop, 5);
    }
#endif
  }
}

void Fl_Window::fullscreen() {
  border(0);
  x(1); // force it to call XResizeWindow()
  resize(0,0,Fl::w(),Fl::h());
}

void Fl_Window::fullscreen_off(int X,int Y,int W,int H) {
  resize(X,Y,W,H);
  border(1);
}

