/* $Id: visual.c,v 1.13 1998/10/18 15:52:29 becka Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1997 Jim Ursetto   [murasaki@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "lin4lib.h"

int GGIdlinit(ggi_visual *visual,const char *version,void *argptr)
{
	/* Color mapping 
	 */
	visual->opcolor->mapcolor=GGI_lin4_mapcolor;
	visual->opcolor->unmappixel=GGI_lin4_unmappixel;
	visual->opcolor->packcolors=GGI_lin4_packcolors;
	visual->opcolor->unpackpixels=GGI_lin4_unpackpixels;

	/* Frame handling
	 */

	visual->opdraw->setreadframe=GGI_default_setreadframe;
	visual->opdraw->setwriteframe=GGI_default_setwriteframe;
	
	/* Generic drawing
	 */
	visual->opdraw->drawpixel_nc=GGI_lin4_drawpixel_nc;
	visual->opdraw->drawpixel=GGI_lin4_drawpixel;
	visual->opdraw->putpixel_nc=GGI_lin4_putpixel_nc;
	visual->opdraw->putpixel=GGI_lin4_putpixel;
	visual->opdraw->getpixel=GGI_lin4_getpixel;

	visual->opdraw->drawhline_nc=GGI_lin4_drawhline_nc;
	visual->opdraw->drawhline=GGI_lin4_drawhline;
	visual->opdraw->puthline=GGI_lin4_puthline;
	visual->opdraw->gethline=GGI_lin4_gethline;

	visual->opdraw->drawvline_nc=GGI_lin4_drawvline_nc;
	visual->opdraw->drawvline=GGI_lin4_drawvline;
	visual->opdraw->putvline=GGI_lin4_putvline;
	visual->opdraw->getvline=GGI_lin4_getvline;

	visual->opdraw->copybox=GGI_lin4_copybox;

	return GGI_DL_OPCOLOR|GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}

#include <ggi/internal/ggidlinit.h>
