/* $Id: vline.c,v 1.9 1998/09/26 03:20:47 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "lin4lib.h"

/********************************/
/* draw/get/put a vertical line */
/********************************/
int GGI_lin4_drawvline(ggi_visual *vis,int x,int y,int height)
{
	uint8 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 shift = (x & 0x01) << 2;
	uint8 color=LIBGGI_GC_FGCOLOR(vis) >> (shift^4);
	uint8 mask = 0x0f << shift;
	
	CHECKXYH(vis,x,y,height);

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*((w+x)>>1);

	for(;height>0;height--,ptr+=w) 
		*ptr=color | (*ptr & mask); 
	
	return 0;
}

int GGI_lin4_drawvline_nc(ggi_visual *vis,int x,int y,int height)
{
	uint8 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 shift = (x & 0x01) << 2;
	uint8 color=LIBGGI_GC_FGCOLOR(vis) >> (shift^4);
	uint8 mask = 0x0f << shift;
	
	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*((w+x)>>1);

	for(;height>0;height--,ptr+=w) 
		*ptr=color | (*ptr & mask); 
	
	return 0;
}

int GGI_lin4_putvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint8 *ptr,*pixels=(uint8 *)buffer;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 shift = (x & 0x01) << 2;
	uint8 mask = 0x0f << shift;
	uint8 antishift = shift ^ 4;
	
	CHECKXYH(vis,x,y,height);

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*((w+x)>>1);

	for(; height > 1; height-=2, ptr+=(w<<1)) {
		*ptr=(*pixels >> shift) | (*ptr & mask);
		*(ptr+w) = (*(pixels++) << antishift) | (*(ptr+w) & mask);
	}
	
	if (height) {
		*ptr=(*pixels >> shift) | (*ptr & mask);
	}
		
	return 0;
}

int GGI_lin4_getvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint8 *ptr,*pixels=(uint8 *)buffer;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 shift = (x & 0x01) << 2;
	uint8 mask = 0x0f << shift;
	uint8 antishift = shift ^ 4;
	
	ptr=(uint8 *)LIBGGI_CURREAD(vis)+y*((w+x)>>1);

	/* Warning: unnecessary bit operations ahead! */
	for (; height > 1; height-=2, ptr+=w<<1) {
		*pixels = ((*ptr & mask) << shift) | ((*(ptr+w) & mask) >> antishift);
	}
	
	/* Here we can't lazily stick the extra pixel into the buffer, since
	 * it might be off the screen. */
	if (height) {
		*pixels = ((*ptr & mask) << shift);
	}
	
	return 0;
}
