/* $Id: box.c,v 1.11 1998/09/26 03:20:57 marcus Exp $
***************************************************************************

   Generic box drawing

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted     [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "stublib.h"

int GGI_stubs_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	/* Do correct clipping so we can use faster _ggiDrawHLineNC */
  
	if (y < LIBGGI_GC(vis)->cliptl.y) {
		int diff = LIBGGI_GC(vis)->cliptl.y - y;
		y += diff;
		h -= diff;
	}
	if (y+h > LIBGGI_GC(vis)->clipbr.y) {
		h = LIBGGI_GC(vis)->clipbr.y - y;
	}
	if (x < LIBGGI_GC(vis)->cliptl.x) {
		int diff = LIBGGI_GC(vis)->cliptl.x - x;
		x += diff;
		w -= diff;
	}
	if (x+w > LIBGGI_GC(vis)->clipbr.x) {
		w = LIBGGI_GC(vis)->clipbr.x - x;
	}

	if ((h <= 0) || (w <= 0)) 
		return 0;

	for (; h > 0; h--, y++) {
		_ggiDrawHLineNC(vis, x, y, w);
	}

	return 0;
}

int GGI_stubs_putbox(ggi_visual *vis, int x, int y, int w, int h, void *buffer)
{ 
	uint8 *src = (uint8 *) buffer;
	int rowadd;


	/* Pre-clipping, so we don't call PutHline without need */

	if (y < LIBGGI_GC(vis)->cliptl.y) {
		int diff = LIBGGI_GC(vis)->cliptl.y - y;
		y += diff;
		h -= diff;
	}
	if (y+h > LIBGGI_GC(vis)->clipbr.y) {
		h = LIBGGI_GC(vis)->clipbr.y - y;
	}

	if ((h < 0) ||
	    (x >= LIBGGI_GC(vis)->clipbr.x) ||
	    (x+w <= LIBGGI_GC(vis)->cliptl.x)) {

		return 0;
	}

	if (LIBGGI_GT(vis) & GT_SUB_PACKED_GETPUT) {
		rowadd = (w * GT_SIZE(LIBGGI_GT(vis)) + 7) / 8;
	} else {
		rowadd = w * ((GT_SIZE(LIBGGI_GT(vis))+7)/8);
	}
	
	for (; h > 0; h--, y++, src += rowadd) {
		ggiPutHLine(vis, x, y, w, src);
	}

	return 0;
}

int GGI_stubs_getbox(ggi_visual *vis, int x, int y, int w, int h, void *buffer)
{ 
	uint8 *dest = (uint8 *) buffer;
	int rowadd;

	/* Unclipped */

	if (LIBGGI_GT(vis) & GT_SUB_PACKED_GETPUT) {
		rowadd = (w * GT_SIZE(LIBGGI_GT(vis)) + 7) / 8;
	} else {
		rowadd = w * ((GT_SIZE(LIBGGI_GT(vis))+7)/8);
	}
	
	for (; h > 0; h--, y++, dest += rowadd) {
		ggiGetHLine(vis, x, y, w, dest);
	}

	return 0;
}
