/* $Id: copybox.c,v 1.8 1998/10/12 22:00:08 marcus Exp $
***************************************************************************
   Graphics library for GGI.

   Copyright (C) 1998 Andrew Apted  [andrew.apted@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "stublib.h"

#define MAX_PIXELS  1024

static inline int copy_one_line(ggi_visual *vis, int x, int y, int w,
				int nx, int ny)
{
	uint8 buf[MAX_PIXELS * sizeof(ggi_pixel)];

	if (nx > x) {
		x  += w; nx += w;
		
		for (; (w > 0); w -= MAX_PIXELS) {

			int ww =  (w < MAX_PIXELS) ? w : MAX_PIXELS;

			ggiGetHLine(vis, x-ww,  y,  ww, buf);
			ggiPutHLine(vis, nx-ww, ny, ww, buf);

			x  -= MAX_PIXELS;
			nx -= MAX_PIXELS;
		}
	} else {
		for (; (w > 0); w -= MAX_PIXELS) {
			
			int ww =  (w < MAX_PIXELS) ? w : MAX_PIXELS;

			ggiGetHLine(vis, x,  y,  ww, buf);
			ggiPutHLine(vis, nx, ny, ww, buf);

			x  += MAX_PIXELS;
			nx += MAX_PIXELS;
		}
	}

	return 0;
}

int GGI_stubs_copybox(ggi_visual *vis, int x, int y, int w, int h, int nx, int ny)
{
	/* Clipping */

	if (nx < LIBGGI_GC(vis)->cliptl.x) {
		int diff = LIBGGI_GC(vis)->cliptl.x - nx;
		x  += diff;
		nx += diff;
		w  -= diff;
	}
	if (ny < LIBGGI_GC(vis)->cliptl.y) {
		int diff = LIBGGI_GC(vis)->cliptl.y - ny;
		y  += diff;
		ny += diff;
		h  -= diff;
	}
	if (nx+w > LIBGGI_GC(vis)->clipbr.x) {
		w = LIBGGI_GC(vis)->clipbr.x - nx;
	}
	if (ny+h > LIBGGI_GC(vis)->clipbr.y) {
		h = LIBGGI_GC(vis)->clipbr.y - ny;
	}

	/* Do the copy */

	if ((h <= 0) || (w <= 0)) {
		return 0;
	}

	if (ny > y) {
		for (y+=h-1, ny+=h-1; (h > 0); h--, y--, ny--) {
			copy_one_line(vis, x, y, w, nx, ny);
		}
	} else {
		for (; (h > 0); h--, y++, ny++) {
			copy_one_line(vis, x, y, w, nx, ny);
		}
	}

	return 0;
}
