/* $Id: gtext.c,v 1.9 1998/09/26 03:21:01 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 MenTaLguY        [mentalg@geocities.com]
   Copyright (C) 1998 Andrew Apted     [andrew.apted@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "stublib.h"

#include <ggi/internal/font/8x8>

int GGI_stubs_getcharsize(ggi_visual *vis, int *width, int *height)
{
	/* The stubs' font is 8x8, so that is what we return */

	*width = *height = 8;
	return 0;
}

static int GGIblit2c(ggi_visual *vis,int x,int y,
				      int xwidth,int ywidth,void *field)
{
	int xp,bp;
	int color;

	/* Clipping is done via the PutPixel call ... we should pre-clip */

	for(;ywidth--;y++) {
		for(xp=0,bp=0x80;xp<xwidth;xp++) {
			color=(*(char *)field & bp) ? LIBGGI_GC_FGCOLOR(vis) 
						    : LIBGGI_GC_BGCOLOR(vis);
			ggiPutPixel(vis,x+xp,y,color);
      			if (!(bp>>=1)) {
				bp=0x80;
				field = ((uint8 *) field) + 1;
			}
    		}
	}

	return 0;
}

int GGI_stubs_putc(ggi_visual *vis,int x,int y,char c)
{
	int char_w, char_h;

	ggiGetCharSize(vis, &char_w, &char_h);

	if ((char_w != 8) && (char_h != 8)) {

		/* Either we're in text mode, or some sub-library has
		 * overridden charsize _without_ overriding putc.
		 */
		DPRINT("generic-stubs: putc was not overridden.\n");
		return -1;
	}

	return GGIblit2c(vis, x, y, 8, 8, font+((uint8)c<<3));
}

/* Write a null-terminated string of characters, returns the number of
 * characters at least partially displayed 
 */

int GGI_stubs_puts(ggi_visual *vis, int x, int y, const char *str)
{
	int count;
	int char_w, char_h;

	ggiGetCharSize(vis, &char_w, &char_h);
	
	/* vertically out of the clipping area ? */

	if ((y+char_h < LIBGGI_GC(vis)->cliptl.y) ||
	    (y >= LIBGGI_GC(vis)->clipbr.y)) {

		return 0;
	}
	    
	for (count=0; *str && (x < LIBGGI_VIRTX(vis));
	     str++, x += char_w) {

		/* horizontally within the clipping area ? */

		if ((x+char_w >= LIBGGI_GC(vis)->cliptl.x) &&
		    (x < LIBGGI_GC(vis)->clipbr.x)) {

			ggiPutc(vis, x, y, *str); 
			count++;
		}
	}

	return count;
}
