/* $Id: color.c,v 1.9 1998/09/20 21:23:30 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted     [andrew.apted@ggi-project.org]

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

	
int GGIgetbpp(ggi_visual *vis)
{
	return 32;
}	

int GGIgetcpp(ggi_visual *vis)
{
	return 256;
}	

/* Standard 16 colors */

static ggi_color ansi_16_colors[16] =
{
	{ 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0xaaaa },
	{ 0x0000, 0xaaaa, 0x0000 },
	{ 0x0000, 0xaaaa, 0xaaaa },
	{ 0xaaaa, 0x0000, 0x0000 },
	{ 0xaaaa, 0x0000, 0xaaaa },
	{ 0xaaaa, 0xaaaa, 0x0000 },
	{ 0xaaaa, 0xaaaa, 0xaaaa },

	{ 0x5555, 0x5555, 0x5555 },
	{ 0x5555, 0x5555, 0xffff },
	{ 0x5555, 0xffff, 0x5555 },
	{ 0x5555, 0xffff, 0xffff },
	{ 0xffff, 0x5555, 0x5555 },
	{ 0xffff, 0x5555, 0xffff },
	{ 0xffff, 0xffff, 0x5555 },
	{ 0xffff, 0xffff, 0xffff }
};

/* Do closest-match-mapping.
 * We use the sum of the squares for distance checking.
 *
 * !!! FIXME: TEXT32 can really do 256 colors.
 */

ggi_pixel GGImapcolor(ggi_visual *vis, ggi_color *col)
{
	int i;
	int closest=0;

	uint32 curdist;


	curdist = (1 << 24) * 4;
	
	for (i=0; i < 16; i++) {

		int dr = (col->r - ansi_16_colors[i].r) >> 4;
		int dg = (col->g - ansi_16_colors[i].g) >> 4;
		int db = (col->b - ansi_16_colors[i].b) >> 4;

		int dist = (dr*dr) + (dg*dg) + (db*db);

		if (dist == 0) {
			/* direct hit */
			break;
		}

		if (dist < curdist) {
			closest = i;
			curdist = dist;
		}
	}

	/* Now put this color into the *foreground* part of the text
	 * pixel, and choose a character that is as solid as possible.
	 */

	return (closest == 0) ? (0x20 << 24) /* space */ :
		((closest << 8) | (0xdb << 24) /* block */ );

}

/* Map pixel to color
 */

int GGIunmappixel(ggi_visual *vis, ggi_pixel pixel, ggi_color *col)
{
	int fg = (pixel & ATTR_FGCOLOR) >> 8;

	*col = ansi_16_colors[fg & 0x0f];   /* !!! FIXME */

	return 0;
}
