/* 
 *   linetest.c
 *
 *   by Andrew Apted <andrew@ggi-project.org>
 *
 *   This is a demonstration of LibGGI's functions and can be used as a
 *   reference programming example.
 *
 *      This software is placed in the public domain and can be used
 *      freely for any purpose. It comes with absolutely NO WARRANTY,
 *      either expressed or implied, including, but not limited to the
 *      implied warranties of merchantability or fitness for a particular 
 *      purpose.  USE IT AT YOUR OWN RISK. the author is not responsible
 *      for any damage or consequences raised by use or inability to use
 *      this program.
 *
 *   Usage: ./linetest [mode-spec]
 *
 *   Test line drawing primitives
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <ggi/ggi.h>

ggi_color black  = { 0x0000, 0x0000, 0x0000 };
ggi_color white  = { 0xffff, 0xffff, 0xffff };

int main(int argc, char *argv[])
{
	ggi_visual_t	vis;
	ggi_mode	mode;

	int x, y, w, h;

	/* Initialize libGGI */
	if(ggiInit()) {
		fprintf(stderr, "Cannot initialize libGGI!\n");
		return EXIT_FAILURE;
	}
	
	/* Open default visual */
	vis = ggiOpen(NULL);
	if(!vis) {
		fprintf(stderr, "Cannot open default visual!\n");
		ggiExit();
		return EXIT_FAILURE;
	}
	
	/* Set visual to async mode (drawing not immediate) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);

	/* Set default mode, but with multiple buffering */
	if (argc>1) {
		ggiParseMode(argv[1], &mode);
	} else {
		ggiParseMode("", &mode);
	}

	if (ggiSetMode(vis, &mode)) {
		fprintf(stderr, "Cannot set mode!\n");
		ggiClose(vis);
		ggiExit();
		return EXIT_FAILURE;
	}

	/* Setup palette */
	if (GT_SCHEME(mode.graphtype) == GT_PALETTE) {
		ggi_color palette[2];
		palette[0] = black;
		palette[0] = white;
		ggiSetPalette(vis, 0, 2, palette);
	}

	/* Draw lines on boxes */

	for (w=4; w < 1024; w <<= 1)
	for (h=4; h < 1024; h <<= 1) {

		x = w + (w/2);
		y = h + (h/2);

		ggiSetGCForeground(vis, ggiMapColor(vis, &white));
		ggiDrawBox(vis, x, y, w, h);

		ggiSetGCForeground(vis, ggiMapColor(vis, &black));
		ggiDrawLine(vis, x, y, x+w-1, y+h-1);
	}	

	ggiFlush(vis);

	/* wait for keypress */
	ggiGetc(vis);
	
	ggiClose(vis);
	ggiExit();
	return EXIT_SUCCESS;
}
