/*
 * mandel.c - (c) 1998 Andreas Beck   becka@ggi-project.org
 *
 * This is a demonstration of LibGGI's functions and can be used as a
 * reference programming example.
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <fcntl.h>
#include <ggi/ggi.h>

ggi_visual_t vis;

struct p { double x1,y1,x2,y2; } w;

double dx,dy;
int xs;
int ys;

int del=119;

int x_1,y_1,x_2,y_2;

char name[1024];

ggi_color aktregs[256];

void delay(int bla)
{ bla*=1000;while(bla--); }

void fade_in(void)
{ ggi_color hregs[256];
  int x,y,z;
  for(x=1024;x>=0;x--)
  {delay(10);
   for(y=0;y<256;y++) { hregs[y].r=(z=aktregs[y].r-x)>0 ? z : 0;
			hregs[y].g=(z=aktregs[y].g-x)>0 ? z : 0;
			hregs[y].b=(z=aktregs[y].b-x)>0 ? z : 0; }
   ggiSetPalette(vis,0,256,hregs);}
}

void fade_out(void)
{ ggi_color hregs[256];
  int x,y,z;
  for(x=0;x<1024;x++)
  {delay(10);
   for(y=0;y<256;y++) { hregs[y].r=(z=aktregs[y].r-x)>0 ? z : 0;
			hregs[y].g=(z=aktregs[y].g-x)>0 ? z : 0;
			hregs[y].b=(z=aktregs[y].b-x)>0 ? z : 0; }
  ggiSetPalette(vis,0,256,hregs);}
}

void savepic(char *name)
{ int h;
  void *scr;
  if ((scr=malloc(xs*ys))==NULL) return;
  ggiGetBox(vis,0,0,xs,ys,scr);
  h=open(name,O_CREAT|O_TRUNC|O_WRONLY,0644);
  write(h,&w,sizeof(w));
  write(h,scr,xs*ys);
  free(scr);
  close(h);
}

int loadpic(char *name)
{ int h;
  void *scr;
  if ((scr=malloc(xs*ys))==NULL) return 0;
  if ((h=open(name,O_RDONLY))==-1) return 0;
  read(h,&w,sizeof(w));
  fade_out();
  read(h,scr,xs*ys);
  close(h);
  ggiPutBox(vis,0,0,xs,ys,scr);
  free(scr);
  fade_in();
  return(1);
}

int load3d(char *name,int deep)
{ int h,x,y,z,v;
  unsigned char buffer;
  if ((h=open(name,O_RDONLY))==-1) return(0);
  read(h,&w,sizeof(w));
  fade_out();
  ggiSetPalette(vis,0,256,aktregs);
  ggiFillscreen(vis);
  deep+=5;
  
  for(y=0;y<ys;y++)
  { v=y*2/3+ys/3;
    for(x=0;x<xs;x++)
    { read(h,&buffer,1);
      z=270-(unsigned)buffer;if (z>deep) z=deep;
      while(z) ggiPutPixel(vis,x,v-z--,buffer);
    }
  }
  close(h);
  return(1);
}

void animate(void)
{ int x;
  ggi_color rem;
  rem=aktregs[1];
  for(x=1;x<255;x++) aktregs[x]=aktregs[x+1];
  aktregs[255]=rem;
  ggiSetPalette(vis,0,256,aktregs);
}

void Animate(void)
{ int x;
  ggi_color rem;
  rem=aktregs[255];
  for(x=254;x>0;x--) aktregs[x+1]=aktregs[x];
  aktregs[1]=rem;
  ggiSetPalette(vis,0,256,aktregs);
}

void vline(int x,int col)
{ char buffer[2048];
  int xx;
  ggiGetVLine(vis,x,0,ys,buffer);
  for(xx=0;xx<ys;xx++) buffer[xx]^=col;
  ggiPutVLine(vis,x,0,ys,buffer);
}
void hline(int y,int col)
{ char buffer[2048];
  int xx;
  ggiGetHLine(vis,0,y,xs,buffer);
  for(xx=0;xx<xs;xx++) buffer[xx]^=col;
  ggiPutHLine(vis,0,y,xs,buffer);
}

int directory(char *name)
{ DIR *dir;
  struct dirent *direntry;
  char hpnam[80];int x,ta;

  struct p werte;int x1,y1,x2,y2;
  
  dx=(w.x2-w.x1)/(double)xs;dy=(w.y2-w.y1)/(double)ys;

  while(1)
  {  ta=0;if ((dir=opendir("."))==NULL) return 0;
     while((direntry=readdir(dir))!=NULL)
     {	strcpy(hpnam,"");strcat(hpnam,direntry->d_name);
        if (strlen(hpnam)<4||strcmp(hpnam+strlen(hpnam)-4,".api")) continue;
	x=open(hpnam,O_RDONLY);read(x,&werte,sizeof(werte));close(x);

	x1=(werte.x1-w.x1)/dx;x2=(werte.x2-w.x1)/dx;
	y1=(werte.y1-w.y1)/dy;y2=(werte.y2-w.y1)/dy;

	if (x1<0||x2>=xs||y1<0||y2>=ys||y2-y1<5||x2-x1<5) continue;

	vline(x1,64);hline(y1,96);vline(x2,64);hline(y2,96);
	ta=ggiGetc(vis);
	vline(x1,64);hline(y1,96);vline(x2,64);hline(y2,96);

	switch(ta)
	 {case 27:return(0);
	  case 13:
	  case 10:strcpy(name,hpnam);return(1);}
     }
   if (ta==0) return(0);
   }
return(0);
}

int waehle_aus(void)
{int x,y,z,l,mode;
 x=y=mode=0;l=1;
 do{ 
   vline(x,32);hline(y,32);
   z=ggiGetc(vis);
   vline(x,32);hline(y,32);

   switch(z) {
   case '0': l=1;break;
   case '1': l=1;break;
   case '2': l=4;break;
   case '3': l=9;break;
   case '4': l=16;break;
   case '5': l=25;break;
   case '6': l=36;break;
   case '7': l=49;break;
   case '8': l=64;break;
   case '9': l=81;break;
   case 'h': x=y=0;break;
   case 'e':x=xs-1;y=ys-1;/* End */break;
   case GIIK_Up   :if (y>=l) y-=l;break;
   case GIIK_Left :if (x>=l) x-=l;break;
   case GIIK_Right:if (x<xs-l) x+=l;break;
   case GIIK_Down :if (y<ys-l) y+=l;break;
   case GIIUC_Return:
	   switch(mode++)
		   {case 0:vline(x,64);hline(y,64);x_1=x;y_1=y;break;
		   case 1:vline(x,64);hline(y,64);x_2=x;y_2=y;
			   if (x<x_1) {x_2=x_1;x_1=x;}
			   if (y<y_1) {y_2=y_1;y_1=y;}
			   break;
		   case 2:mode=0;
			   vline(x_1,64);hline(y_1,64);
			   vline(x_2,64);hline(y_2,64);break;
		   }
   }
 }while(z!=27);
 return(mode);
}

int main(int argc,char *argv[])
{ int x,y,c;double xx,yy;
  register  double ax,ay,qx,qy;
  w.x1=-2;w.x2=1;w.y1=-1.3;w.y2=1.3;

  if (argc<2) {fputs("mandel [x1] [x2] [y1] [y2] to calc pic\n"
		     "mandel filename            to view pic\n",stderr);return 1;}

  if (ggiInit() != 0) {
	fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
		argv[0]);
	exit(1);
  }
  if ((vis=ggiOpen(NULL)) == NULL) {
	  fprintf(stderr,
		  "%s: unable to open default visual, exiting.\n",
		  argv[0]);
	  exit(1);
  }
  if (ggiSetGraphMode(vis,GGI_AUTO,GGI_AUTO,GGI_AUTO,GGI_AUTO,GT_8BIT))
    ggiPanic("Cannot open default mode.");

  { ggi_mode mode;
    ggiGetMode(vis,&mode);xs=mode.visible.x;ys=mode.visible.y;
  }

  for(x=0;x<255;x++) aktregs[x].r=aktregs[x].g=aktregs[x].b=0;
  for(x=0;x<64;x++) {   aktregs[  1+x].r=x<<10;
  			aktregs[127-x].r=x<<10;
			aktregs[ 64+x].g=x<<10;
			aktregs[191-x].g=x<< 8;
			aktregs[ 64-x].g=(x/3)<<10;
			aktregs[192+x].g=(x/3)<<10;
			aktregs[ 64-x].r=x<<10;
			aktregs[192+x].r=x<<10;
			aktregs[ 64-x].b=x<< 9;
			aktregs[192+x].b=x<< 9;
			aktregs[128+x].b=x<<10;
			aktregs[255-x].b=x<<10;}
  ggiSetPalette(vis,0,256,aktregs);

  if (argc==2&&loadpic(argv[1])) c=0; else
 {if (argc>1) sscanf(argv[1],"%lf",&w.x1);
  if (argc>2) sscanf(argv[2],"%lf",&w.x2);
  if (argc>3) sscanf(argv[3],"%lf",&w.y1);
  if (argc>4) sscanf(argv[4],"%lf",&w.y2);c=2;}

 calc_it:
 if (c==2)
 { dx=(w.x2-w.x1)/(double)xs;
   dy=(w.y2-w.y1)/(double)ys;

   for(y=0,yy=w.y1;y<ys;y++,yy+=dy)
   { xx=w.x1;
     /*if (kbhit()) {if (ggiGetc(vis)==27) y=ys; }*/
     for(x=0;x<xs;x++,xx+=dx)
     { c=256;ax=ay=0.0;
       while(--c&&(qx=ax*ax)+(qy=ay*ay)<4)
       { ay=2.0*ax*ay+yy;ax=qx-qy+xx; }
       ggiPutPixel(vis,x,y,c);
 } } }
  do{
    switch(c=ggiGetc(vis))
    {case 'a':animate();break;
     case 'A':Animate();break;
     case 's':/*savewin();gotoxy(1,1);puts("Filename : ");gotoxy(12,1);*/
	      if (scanf("%s",name)) {strcat(name,".api");savepic(name);}
	      break;
     case 'l':/*savewin();gotoxy(1,1);puts("Filename : ");gotoxy(12,1);*/
	      if (scanf("%s",name)) {strcat(name,".api");loadpic(name);}
	      break;
     case '3':/*savewin();gotoxy(1,1);puts("Filename : ");gotoxy(12,1);*/
	      if (scanf("%s",name)) {/*c=30;gotoxy(1,1);puts("Tiefe Max: ");
				     gotoxy(12,1);*/scanf("%d",&c);
				     strcat(name,".api");load3d(name,c);}
	      c=0;break;
     case 'd':if (directory(name)) loadpic(name);break;
     case 'w':c=waehle_aus();dx=(w.x2-w.x1)/(double)xs;dy=(w.y2-w.y1)/(double)ys;
	      xx=w.x1;yy=w.y1;w.x1=xx+x_1*dx;w.x2=xx+(x_2+1.0)*dx;
	      w.y1=yy+y_1*dy;w.y2=yy+(y_2+1.0)*dy;
	      goto calc_it;
  } }while(c!=27);
 ggiClose(vis);
 ggiExit();
 return(0);
}
