/* $Id: filehook.h,v 1.5 1998/10/13 11:13:59 ajapted Exp $
***************************************************************************

   Display-file: definitions

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>


typedef int  (file_detect_func)(char *filename);
typedef void (file_writer_func)(ggi_visual *vis);

#define FILE_BUFFER_SIZE  1024


typedef struct file_hook
{
	int flags;

	char *filename;

	file_writer_func *writer;

	int    fb_size;
	int    fb_stride;
	uint8 *fb_ptr;
	
	int num_cols;

	/* raw mode */

	int offset_pal;
	int offset_image;

	int    file_size;
	uint8 *file_mmap;

	/* output buffering */

	int buf_len;
	uint8 buffer[FILE_BUFFER_SIZE];

} FileHook;

#define FILEFLAG_RAW	0x0001

#define FILE_PRIV(vis)	((FileHook *) LIBGGI_PRIVATE(vis))


#define ROUND_UP_SIZE  (4*1024)   /* FIXME: depends on page size */


/* File Primitives
 */

extern int  _ggi_file_create_file(ggi_visual *vis, char *filename);
extern void _ggi_file_close_file(ggi_visual *vis);
extern void _ggi_file_flush(ggi_visual *vis);

extern void _ggi_file_write_byte(ggi_visual *vis, int val);
extern void _ggi_file_write_word(ggi_visual *vis, int val);
extern void _ggi_file_write_string(ggi_visual *vis, char *str);
extern void _ggi_file_write_zeros(ggi_visual *vis, int count);


/* Image Writers 
 */
 
extern file_detect_func _ggi_file_ppm_detect;
extern file_writer_func _ggi_file_ppm_write;


/* LibGGI Interface
 */
 
ggifunc_getmode		GGI_file_getmode;
ggifunc_setmode		GGI_file_setmode;
ggifunc_resetmode	GGI_file_resetmode;
ggifunc_checkmode	GGI_file_checkmode;
ggifunc_getapi		GGI_file_getapi;
ggifunc_setflags	GGI_file_setflags;
ggifunc_setpalvec	GGI_file_setpalvec;


/**************************************************************************

RAW FILE FORMAT
===============

   FILE = header [ palette ] padding image.

   header = magic width height graphtype stride padsize.

   magic = 0x10 "GGIFILE".

   width, height, padsize, stride = <high byte> <low byte>.

   graphtype = <scheme byte> <subscheme byte> <size byte> <depth byte>.

   palette = color...        // number of colors is (1<<depth)

   color = <red byte> <green byte> <blue byte>.

   padding = <zero byte>...  // number of zeros given by padsize
                             // (Note: the header + palette is padded
                             // to a multible of the image stride)
   image = <image byte>...

**************************************************************************/
