/* $Id: memvisual.h,v 1.6 1998/10/21 21:52:29 becka Exp $
***************************************************************************

   Display-memory: headers

   Copyright (C) 1997 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#define INPBUFSIZE	8192
#define MEMINPMAGIC	'M'

#ifdef HAVE_SYS_SHM_H
#define HAVE_SHM
#include <sys/shm.h>
#endif

ggifunc_getmode		GGI_memory_getmode;
ggifunc_setmode		GGI_memory_setmode;
ggifunc_getapi		GGI_memory_getapi;
ggifunc_checkmode	GGI_memory_checkmode;
ggifunc_setflags	GGI_memory_setflags;
ggifunc_setpalvec	GGI_memory_setpalvec;

enum memtype { 
	MT_MALLOC, 		/* No parameters  : memory is malloced */
	MT_EXTERN, 		/* only a pointer : draw there. Take care it is big enough. */
	MT_SHMID, 		/* "shmid:%i"     : map shared memory at shmid */
	MT_SHMKEYFILE 		/* "keyfile:%c:%s": create and map shared mem corresponding to keyfile see ftok */
};

typedef struct {
	int writeoffset;	/* We should lock access to that one ... */
	char buffer[1];		/* This index will be used "overflowing" */
} inpbuffer;

struct memhooks { 
	enum memtype memtype;
	void *memptr;
	inpbuffer *inputbuffer;
	int  inputoffset;
#ifdef HAVE_SHM
	int	shmid;
#endif
};

#define MEMLIB_PRIV(vis) ((struct memhooks *)LIBGGI_PRIVATE(vis))

int _GGI_memory_resetmode(ggi_visual *vis);
