/* $Id: events.c,v 1.5 1998/09/23 21:38:11 marcus Exp $
***************************************************************************

   Display-multi: events

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#include "multi_defs.h"


/* !!! FIXME such that we receive events from *all* sub-targets, not
 * just the head one.
 */

ggi_event_mask GGI_multi_eventpoll(ggi_visual_t vis, ggi_event_mask mask,
			    struct timeval *t)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiEventPoll(mm->vis_list->vis, mask, t);
}

int GGI_multi_eventread(ggi_visual_t vis, ggi_event *ev, ggi_event_mask mask)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiEventRead(mm->vis_list->vis, ev, mask);
}
