/* $Id: stubs.c,v 1.10 1998/09/25 21:32:52 becka Exp $
***************************************************************************

   Display-sub: stubs

   Copyright (C) 1998 Andreas Beck    [becka@ggi-project.org]
   Copyright (C) 1998 Rudolphe Ortalo

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

/* FIXME: Should we adjust parent clipping for "get" calls ? */

#include <ggi/internal/ggi-dl.h>
#include "SubVisual.h"

#define IS_SAVING_GC	ggi_pixel _foreground, _background; \
			int _l,_t,_r,_b;

#define SETUP_AND_SAVE_GC \
		do {	_foreground = LIBGGI_GC(hook->parent)->fg_color; \
			_background = LIBGGI_GC(hook->parent)->bg_color; \
			_l = LIBGGI_GC(hook->parent)->cliptl.x; \
			_t = LIBGGI_GC(hook->parent)->cliptl.y; \
			_r = LIBGGI_GC(hook->parent)->clipbr.x; \
			_b = LIBGGI_GC(hook->parent)->clipbr.y; \
			LIBGGI_GC(hook->parent)->fg_color = LIBGGI_GC(vis)->fg_color; \
			LIBGGI_GC(hook->parent)->bg_color = LIBGGI_GC(vis)->bg_color; \
			LIBGGI_GC(hook->parent)->cliptl.x=LIBGGI_GC(vis)->cliptl.x+hook->position.x; \
		   	LIBGGI_GC(hook->parent)->cliptl.y=LIBGGI_GC(vis)->cliptl.y+hook->position.y; \
		   	LIBGGI_GC(hook->parent)->clipbr.x=LIBGGI_GC(vis)->clipbr.x+hook->position.x; \
		   	LIBGGI_GC(hook->parent)->clipbr.y=LIBGGI_GC(vis)->clipbr.y+hook->position.y; \
			/* check limits... (in case leaving visual) */ \
			if (LIBGGI_GC(hook->parent)->clipbr.x > hook->botright.x) \
				LIBGGI_GC(hook->parent)->clipbr.x = hook->botright.x; \
			if (LIBGGI_GC(hook->parent)->clipbr.y > hook->botright.y) \
				LIBGGI_GC(hook->parent)->clipbr.y = hook->botright.y; \
			/* ensure update in KGI */ \
			LIBGGI_GC(hook->parent)->version++; \
		} while (0);

#define RESTORE_GC \
		do {	LIBGGI_GC(hook->parent)->fg_color = _foreground; \
			LIBGGI_GC(hook->parent)->bg_color = _background; \
			LIBGGI_GC(hook->parent)->cliptl.x= _l; \
		   	LIBGGI_GC(hook->parent)->cliptl.y= _t; \
		   	LIBGGI_GC(hook->parent)->clipbr.x= _r; \
		   	LIBGGI_GC(hook->parent)->clipbr.y= _b; \
			/* ensure update in KGI */ \
			LIBGGI_GC(hook->parent)->version++; \
		} while (0);


/*
**	Functions undergoing a translation
**	with GC saving/restoring
*/

/* NB: Here the src is not directly translated... */
int GGI_sub_crossblit(ggi_visual *src, int sx, int sy, int w, int h,
		 ggi_visual *vis, int dx, int dy)
{
	SubHook *hook=LIBGGI_PRIVATE(vis); // Destination is subvisual
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiCrossBlit(src, sx, sy, w, h, hook->parent,
		      dx+hook->position.x, dy+hook->position.y);
	RESTORE_GC;
	return err;
}

int GGI_sub_drawbox(ggi_visual *vis,int x,int y,int width,int length)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiDrawBox(hook->parent,x+hook->position.x,y+hook->position.y,width,length);
	RESTORE_GC;
	return err;
}

int GGI_sub_putbox(ggi_visual *vis,int x,int y,int width,int length,void *buffer)
{ 
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiPutBox(hook->parent,x+hook->position.x,y+hook->position.y,width,length,buffer);
	RESTORE_GC;
	return err;
}

int GGI_sub_getbox(ggi_visual *vis,int x,int y,int width,int length,void *buffer)
{ 
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiGetBox(hook->parent,x+hook->position.x,y+hook->position.y,width,length,buffer);
	RESTORE_GC;
	return err;
}

int GGI_sub_fillscreen(ggi_visual *vis)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiDrawBox(hook->parent, hook->position.x,hook->position.y,
					hook->botright.x-hook->position.x,
					hook->botright.y-hook->position.y);
	RESTORE_GC;
	return err;
}

int GGI_sub_putc(ggi_visual *vis,int x,int y,char c)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiPutc(hook->parent,x+hook->position.x,y+hook->position.y,c);
	RESTORE_GC;
	return err;
}


int GGI_sub_puts(ggi_visual *vis,int x,int y,const char *str)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiPuts(hook->parent,x+hook->position.x,y+hook->position.y,str);
	RESTORE_GC;
	return err;
}

int GGI_sub_drawhline(ggi_visual *vis,int x,int y,int w)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiDrawHLine(hook->parent,x+hook->position.x,y+hook->position.y,w);
	RESTORE_GC;
	return err;
}

int GGI_sub_drawline(ggi_visual *vis,int x1,int y1,int x2,int y2)
{ 
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiDrawLine(hook->parent,x1+hook->position.x,y1+hook->position.y,
			x2+hook->position.x,y2+hook->position.y);
	RESTORE_GC;
	return err;
}

int GGI_sub_drawvline(ggi_visual *vis,int x,int y,int height)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiDrawVLine(hook->parent,x+hook->position.x,y+hook->position.y,height);
	RESTORE_GC;
	return err;
}

int GGI_sub_drawpixel(ggi_visual *vis,int x,int y)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiDrawPixel(hook->parent,x+hook->position.x,y+hook->position.y);
	RESTORE_GC;
	return err;
}

int GGI_sub_putpixel(ggi_visual *vis,int x,int y,ggi_uint col)
{ 
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiPutPixel(hook->parent,x+hook->position.x,y+hook->position.y,col);
	RESTORE_GC;
	return err;
}

int GGI_sub_getpixel(ggi_visual *vis,int x,int y,ggi_uint *col)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiGetPixel(hook->parent,x+hook->position.x,y+hook->position.y,col);
	RESTORE_GC;
	return err;
}

int GGI_sub_puthline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiPutHLine(hook->parent,x+hook->position.x,y+hook->position.y,w,buffer);
	RESTORE_GC;
	return err;
}

int GGI_sub_gethline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiGetHLine(hook->parent,x+hook->position.x,y+hook->position.y,w,buffer);
	RESTORE_GC;
	return err;
}

int GGI_sub_putvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiPutVLine(hook->parent,x+hook->position.x,y+hook->position.y,height,buffer);
	RESTORE_GC;
	return err;
}

int GGI_sub_getvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiGetVLine(hook->parent,x+hook->position.x,y+hook->position.y,height,buffer);
	RESTORE_GC;
	return err;
}

int GGI_sub_copybox(ggi_visual *vis,int x,int y,int w,int h,int nx,int ny)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	int err;
	IS_SAVING_GC;

	SETUP_AND_SAVE_GC;
	err = ggiCopyBox(hook->parent,x+hook->position.x,y+hook->position.y,w,h,nx,ny);
	RESTORE_GC;
	return err;
}

/*
**	Simple "call parent" functions
*/

int GGI_sub_setgammamap(ggi_visual *vis,int start,int len,ggi_color *colormap)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	/* Should we allow that ? */
	return ggiSetGammaMap(hook->parent,start,len,colormap);
}

int GGI_sub_getgammamap(ggi_visual *vis,int start,int len,ggi_color *colormap)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	return ggiGetGammaMap(hook->parent,start,len,colormap);
}


int GGI_sub_getgamma(ggi_visual *vis,ggi_float *r,ggi_float *g,ggi_float *b)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	return ggiGetGamma(hook->parent,r,g,b);
}

int GGI_sub_setgamma(ggi_visual *vis,ggi_float r,ggi_float g,ggi_float b)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	/* Should we allow that ? */
	return ggiSetGamma(hook->parent,r,g,b);
} 

ggi_pixel GGI_sub_mapcolor(ggi_visual *vis,ggi_color *col)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	return ggiMapColor(hook->parent,col);
}

int GGI_sub_unmappixel(ggi_visual *vis,ggi_uint pixel,ggi_color *col)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	return ggiUnmapPixel(hook->parent,pixel,col);
}

int GGI_sub_setpalvec(ggi_visual *vis,int start,int len,ggi_color *colormap)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	/* Should we allow that ? */
	return ggiSetPalette(hook->parent,start,len,colormap);
}

int GGI_sub_getpalvec(ggi_visual *vis,int start,int len,ggi_color *colormap)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	return ggiGetPalette(hook->parent,start,len,colormap);
}

ggi_event_mask GGI_sub_eventpoll(ggi_visual_t vis,ggi_event_mask mask,
				 struct timeval *t)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	return ggiEventPoll(hook->parent,mask,t);
}

int GGI_sub_eventread(ggi_visual_t vis,ggi_event *ev,ggi_event_mask mask)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);

	return ggiEventRead(hook->parent,ev,mask);
}

/*
**	Functions that are deactivated !
*/ 

int GGI_sub_setorigin(ggi_visual *vis,int x,int y)
{
	return -1;
}


