/* $Id: events.c,v 1.21 1998/10/29 11:58:57 ajapted Exp $
***************************************************************************

   SVGAlib target: events

   Copyright (C) 1998 Steve Cheng      [steve@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include <string.h>

#include <sys/ioctl.h>

#include <linux/kd.h>
#include <linux/keyboard.h>

#include <ggi/internal/ggi-dl.h>
#include "vgavisual.h"
#define WANT__NewEvent
#include "../common/evqueue.inc"

extern char *_GGIkeystate;
extern ggi_visual_t _GGI_ev_vis;

#include "../Linux_common/key_trans.inc"

void _GGIkeyboardhandler(int scancode, int press)
{
	ggi_event ggievent;
	struct kbentry entry;
	unsigned char buf[32];

	__NewEvent(&ggievent);

	ggievent.any.size=sizeof(ggi_key_event);

	if(press) {
		ggievent.any.type = _GGIkeystate[scancode] ? evKeyRepeat : evKeyPress;
		ggievent.key.button = scancode;
		_GGIkeystate[scancode] = 1;
	}
	else {
		ggievent.any.type = evKeyRelease;
		ggievent.key.button = scancode;
		_GGIkeystate[scancode] = 0;
	}	

	/* Get the kernel's shift state.  This is easier than keeping
	 * track of it ourselves.   
	 */
	buf[0] = 6;

	if (ioctl(LIBGGI_SELECT_FD(_GGI_ev_vis), TIOCLINUX, buf) < 0) {
		DPRINT("display-svga: Couldn't read shift state.\n");
		entry.kb_table = 0;
	}

	ggievent.key.effect = buf[0];


	/* look up the keysym in the kernel's table */
	entry.kb_table = ggievent.key.effect;
	entry.kb_index = ggievent.key.button;

	if (ioctl(LIBGGI_SELECT_FD(_GGI_ev_vis), KDGKBENT, &entry) < 0) {
		DPRINT("display-svga: ioctl(KDGKBENT) failed.\n");
		return;
	}

	ggievent.key.sym = translate_sym(entry.kb_value, ggievent.key.effect);


	/* Do it one more time to get the key 'label' */
	entry.kb_table = 0;

	if (ioctl(LIBGGI_SELECT_FD(_GGI_ev_vis), KDGKBENT, &entry) < 0) {
		DPRINT("display-svga: ioctl(KDGKBENT) failed.\n");
		return;
	}

	ggievent.key.label = translate_label(entry.kb_value, 
				ggievent.key.effect);

	DPRINT_EVENTS("display-svga: _GGIkeyboardhandler: effect 0x%X, "
		"button 0x%X, sym 0x%X, label 0x%X\n", 
		ggievent.key.effect, ggievent.key.button, 
		ggievent.key.sym, ggievent.key.label);

	_ggiEvQueueAdd(_GGI_ev_vis,&ggievent);
}	

void _GGImousehandler(int button, int dx, int dy, int dz,
	int drx, int dry, int drz)
{
	static int last_button = 0;
	int button_change;
	ggi_event ggievent;

	__NewEvent(&ggievent);

	/* Mouse movement */
	if(dx || dy || dz || drx || dry || drz) {
		ggievent.any.type=evPtrRelative;
		ggievent.any.size=sizeof(ggi_pmove_event);
		ggievent.pmove.x=dx;
		ggievent.pmove.y=dy;

		DPRINT("mouse move: dx: %d, dy: %d, dz: %d, drx: %d, dry: %d, drz: %d\n",
			dx, dy, dz, drx, dry, drz);
		
		_ggiEvQueueAdd(_GGI_ev_vis,&ggievent);
	}
	
	/* Buttons changed? */
	button_change = button ^ last_button;
	last_button = button;

	ggievent.any.size=sizeof(ggi_pbutton_event);

#if 0
	i = 0;
	while(button_change ^= i)
	{
		switch(button_change)
		{
		case MOUSE_LEFTBUTTON: i = MOUSE_LEFTBUTTON;
			ggievent.pbutton.button = 1; break;
		case MOUSE_RIGHTBUTTON: i = MOUSE_RIGHTBUTTON;
			ggievent.pbutton.button = 2; break;
		case MOUSE_MIDDLEBUTTON: i = MOUSE_MIDDLEBUTTON;
			ggievent.pbutton.button = 4; break;
#ifdef MOUSE_FOURTHBUTTON
		case MOUSE_FOURTHBUTTON: i = MOUSE_FOURTHBUTTON;
			ggievent.pbutton.button = 8; break;
		case MOUSE_FIFTHBUTTON: i = MOUSE_FIFTHBUTTON;
			ggievent.pbutton.button = 16; break;
		case MOUSE_SIXTHBUTTON: i = MOUSE_SIXTHBUTTON;
			ggievent.pbutton.button = 32; break;
		case MOUSE_RESETBUTTON: i = MOUSE_RESETBUTTON;
			ggievent.pbutton.button = 64; break;
#endif
		}
		
		if(button & i) {
			ggievent.pbutton.state = 1;
			ggievent.any.type = evPtrButtonPress;
		} else {
			ggievent.pbutton.state = 0;
			ggievent.any.type = evPtrButtonRelease;
		}

		_ggiEvQueueAdd(_GGI_ev_vis, &ggievent);
	}
#endif

	if(button_change & MOUSE_LEFTBUTTON) {
		ggievent.pbutton.button = 1;
		if(button & MOUSE_LEFTBUTTON) {
			ggievent.pbutton.state = 1;
			ggievent.any.type = evPtrButtonPress;
		} else {
			ggievent.pbutton.state = 0;
			ggievent.any.type = evPtrButtonRelease;
		}
		_ggiEvQueueAdd(_GGI_ev_vis,&ggievent);
	}
	if(button_change & MOUSE_RIGHTBUTTON) {
		ggievent.pbutton.button = 2;
		if(button & MOUSE_RIGHTBUTTON) {
			ggievent.pbutton.state = 1;
			ggievent.any.type = evPtrButtonPress;
		} else {
			ggievent.pbutton.state = 0;
			ggievent.any.type = evPtrButtonRelease;
		}
		_ggiEvQueueAdd(_GGI_ev_vis,&ggievent);
	}
	if(button_change & MOUSE_MIDDLEBUTTON) {
		ggievent.pbutton.button = 4;
		if(button & MOUSE_MIDDLEBUTTON) {
			ggievent.pbutton.state = 1;
			ggievent.any.type = evPtrButtonPress;
		} else {
			ggievent.pbutton.state = 0;
			ggievent.any.type = evPtrButtonRelease;
		}
		_ggiEvQueueAdd(_GGI_ev_vis,&ggievent);
	}
#ifdef MOUSE_FOURTHBUTTON
	if(button_change & MOUSE_FOURTHBUTTON) {
		ggievent.pbutton.button = 8;
		if(button & MOUSE_FOURTHBUTTON) {
			ggievent.pbutton.state = 1;
			ggievent.any.type = evPtrButtonPress;
		} else {
			ggievent.pbutton.state = 0;
			ggievent.any.type = evPtrButtonRelease;
		}
		_ggiEvQueueAdd(_GGI_ev_vis,&ggievent);
	}
	if(button_change & MOUSE_FIFTHBUTTON) {
		ggievent.pbutton.button = 16;
		if(button & MOUSE_FIFTHBUTTON) {
			ggievent.pbutton.state = 1;
			ggievent.any.type = evPtrButtonPress;
		} else {
			ggievent.pbutton.state = 0;
			ggievent.any.type = evPtrButtonRelease;
		}
		_ggiEvQueueAdd(_GGI_ev_vis,&ggievent);
	}
	if(button_change & MOUSE_SIXTHBUTTON) {
		ggievent.pbutton.button = 32;
		if(button & MOUSE_SIXTHBUTTON) {
			ggievent.pbutton.state = 1;
			ggievent.any.type = evPtrButtonPress;
		} else {
			ggievent.pbutton.state = 0;
			ggievent.any.type = evPtrButtonRelease;
		}
		_ggiEvQueueAdd(_GGI_ev_vis,&ggievent);
	}
	if(button_change & MOUSE_RESETBUTTON) {
		ggievent.pbutton.button = 64;
		if(button & MOUSE_RESETBUTTON) {
			ggievent.pbutton.state = 1;
			ggievent.any.type = evPtrButtonPress;
		} else {
			ggievent.pbutton.state = 0;
			ggievent.any.type = evPtrButtonRelease;
		}
		_ggiEvQueueAdd(_GGI_ev_vis,&ggievent);
	}
#endif
}

/************************** GGI Functions ***************************/
/* Event Handling */
ggi_event_mask GGI_svga_eventpoll(ggi_visual_t vis,ggi_event_mask mask,
				  struct timeval *t)
{
	fd_set fds;
	int err;
	struct timeval *timeout,t_zero={0,0};
	ggi_event_mask evmask;

DPRINT("GGIeventpoll(%p,0x%.8x",vis,mask);
if (t==NULL) {
	DPRINT(",NULL)\n");
} else {
	DPRINT(",{%d,%d})\n",t->tv_sec,t->tv_usec);
}

	evmask=_ggiEvQueueSeen(vis,mask);
	if (evmask!=0)
		return evmask;

	if (LIBGGI_SELECT_FD(vis) < 0)
		return 0;

	timeout = &t_zero;
	do {

		/* SVGAlib bug compability!!! input fds can't be null pointer */
		FD_ZERO(&fds);
		err=vga_waitevent(VGA_KEYEVENT | VGA_MOUSEEVENT,
			&fds,NULL,NULL,timeout);

		if(err<0)
			return 0;

		timeout=t;

		/* vga_waitevent() calls our event handler,
		   it _ggiEvQueueAdd()s its events.
		   Okay, no locking problems.*/

		evmask = _ggiEvQueueSeen(vis,mask);

	} while (evmask==0 && t==NULL);

	return evmask;
}

int GGI_svga_eventread(ggi_visual_t vis,ggi_event *ev,ggi_event_mask mask)
{
	/* Block if we don't have anything queued... */
	GGI_svga_eventpoll(vis,mask,NULL);
	return _ggiEvQueueRelease(vis,ev,mask);
}
