/* $Id: fillscreen.c,v 1.6 1998/09/25 21:33:15 becka Exp $
***************************************************************************

   SVGAlib target vgagl helper: fill screen

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>
#include <ggi/internal/ggi-dl.h>
#include "vgaglvis.h"

/*************************************/
/* fill (erase) the (virtual) screen */
/*************************************/

int GGI_vgagl_fillscreen(ggi_visual *vis)
{
	
	if (LIBGGI_GC(vis)->cliptl.x > 0
		|| LIBGGI_GC(vis)->cliptl.y > 0
		|| LIBGGI_GC(vis)->clipbr.x < LIBGGI_MODE(vis)->virt.x
		|| LIBGGI_GC(vis)->clipbr.y < LIBGGI_MODE(vis)->virt.x)
		gl_fillbox(LIBGGI_GC(vis)->cliptl.x,
				   LIBGGI_GC(vis)->cliptl.y,
				   LIBGGI_GC(vis)->clipbr.x-LIBGGI_GC(vis)->cliptl.x,
				   LIBGGI_GC(vis)->clipbr.y-LIBGGI_GC(vis)->cliptl.y,
				   LIBGGI_GC_FGCOLOR(vis));
	else
		gl_clearscreen(LIBGGI_GC_FGCOLOR(vis));
	return 0;
}
