/* $Id: pixel.c,v 1.9 1998/09/25 21:33:17 becka Exp $
***************************************************************************

   SVGAlib target vgagl helper: pixel

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "vgaglvis.h"

/*******************************/
/* draw/get/put a single pixel */
/*******************************/

int GGI_vgagl_drawpixel_nc(ggi_visual *vis,int x,int y)
{
	gl_setpixel(x,y,LIBGGI_GC_FGCOLOR(vis));

	return 0;
}

int GGI_vgagl_drawpixel(ggi_visual *vis,int x,int y)
{
	/* This already clips right. */
	CHECKXY(vis,x,y);
	
	gl_setpixel(x,y,LIBGGI_GC_FGCOLOR(vis));

	return 0;
}

int GGI_vgagl_putpixel_nc(ggi_visual *vis,int x,int y,ggi_pixel col)
{ 
	gl_setpixel(x,y,col);

	return 0;
}

int GGI_vgagl_putpixel(ggi_visual *vis,int x,int y,ggi_pixel col)
{ 
	CHECKXY(vis,x,y);

	gl_setpixel(x,y,col);

	return 0;
}

int GGI_vgagl_getpixel(ggi_visual *vis,int x,int y,ggi_pixel *pixel)
{ 
	*pixel=gl_getpixel(x,y);
	
	return 0;
}
