/* $Id: visual.c,v 1.10 1998/10/18 15:53:11 becka Exp $
***************************************************************************

   SVGAlib target vgagl helper: initialization

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <ggi/internal/ggi-dl.h>
#include "vgaglvis.h"

int GGIdlinit(ggi_visual *visual,const char *args,void *argptr)
{
	if (args==NULL
		|| strncmp(args,"sVgALIb",7) != 0)
		return GGI_DL_ERROR;
	
	gl_setcontextvga(vga_getcurrentmode());

	/* Generic drawing
	 */
	visual->opdraw->drawpixel_nc=GGI_vgagl_drawpixel_nc;
	visual->opdraw->drawpixel=GGI_vgagl_drawpixel;
	visual->opdraw->putpixel_nc=GGI_vgagl_putpixel_nc;
	visual->opdraw->putpixel=GGI_vgagl_putpixel;
	visual->opdraw->getpixel=GGI_vgagl_getpixel;

	visual->opdraw->drawhline_nc=GGI_vgagl_drawhline_nc;
	visual->opdraw->drawhline=GGI_vgagl_drawhline;
	visual->opdraw->gethline=GGI_vgagl_gethline;
	visual->opdraw->puthline=GGI_vgagl_puthline;

	visual->opdraw->drawvline_nc=GGI_vgagl_drawvline_nc;
	visual->opdraw->drawvline=GGI_vgagl_drawvline;
	visual->opdraw->getvline=GGI_vgagl_getvline;
	visual->opdraw->putvline=GGI_vgagl_putvline;
	
	visual->opdraw->drawbox=GGI_vgagl_drawbox;
	visual->opdraw->putbox=GGI_vgagl_putbox;
	visual->opdraw->getbox=GGI_vgagl_getbox;
	visual->opdraw->fillscreen=GGI_vgagl_fillscreen;

	/* 
	visual->opdraw->putc=GGI_vgagl_putc;
	visual->opdraw->getcharsize=GGI_vgagl_getcharsize;
	visual->opdraw->drawline=GGI_vgagl_drawline;
	visual->opdraw->crossblit=GGI_vgagl_crossblit;
	*/

	return GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}

#include <ggi/internal/ggidlinit.h>
