/* $Id: dltypes.h,v 1.5 1998/10/18 15:53:18 becka Exp $
***************************************************************************

   LibGGI - typedefs for internal API functions

   Copyright (C) 1998	Marcus Sundberg		[marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
  
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _GGI_INTERNAL_DLTYPES_H
#define _GGI_INTERNAL_DLTYPES_H

#include <ggi/types.h>

/*
***************************************************************************
 Exported functions
***************************************************************************
*/

/* 
 * Returns the mask of the `vis->op*' types it modified,
 * or GGI_DL_ERROR|errorcode if error 
 */
int GGIdlinit(struct ggi_visual *vis,const char *arg, void *argptr);
int GGIdlcleanup(struct ggi_visual *vis);


/*
***************************************************************************
 Typedef internal funtion types
***************************************************************************
*/

/* Event handling routines */
typedef ggi_event_mask (ggifunc_eventpoll)(struct ggi_visual *vis, ggi_event_mask mask, struct timeval *tv);
typedef int (ggifunc_eventread)(struct ggi_visual *vis,ggi_event *ev,ggi_event_mask mask);
typedef int (ggifunc_seteventmask)(struct ggi_visual *vis, ggi_event_mask mask);

/* Mode Setting routines */
typedef int (ggifunc_getmode)(struct ggi_visual *vis,ggi_mode *tm);
typedef int (ggifunc_setmode)(struct ggi_visual *vis,ggi_mode *tm);
typedef int (ggifunc_checkmode)(struct ggi_visual *vis,ggi_mode *tm);
typedef int (ggifunc_resetmode)(struct ggi_visual *vis);

/* Flag settings */
typedef int (ggifunc_setflags)(struct ggi_visual *vis,ggi_flags flags);

/* Flushing the display
 */
typedef int (ggifunc_flush)(struct ggi_visual *vis, int tryflag);

/* Frame handling
 */

typedef int (ggifunc_setdisplayframe)(struct ggi_visual *vis, int num);
typedef int (ggifunc_setreadframe)(struct ggi_visual *vis, int num);
typedef int (ggifunc_setwriteframe)(struct ggi_visual *vis, int num);

/* Generic drawing routines
 */
typedef ggi_pixel (ggifunc_mapcolor)(struct ggi_visual *vis,ggi_color *color);
typedef int (ggifunc_unmappixel)(struct ggi_visual *vis,ggi_pixel pixel,ggi_color *color);
typedef int (ggifunc_packcolors)(struct ggi_visual *vis,void *buf,ggi_color *colors,int len);
typedef int (ggifunc_unpackpixels)(struct ggi_visual *vis,void *buf,ggi_color *colors,int len);

typedef int (ggifunc_setpalvec)(struct ggi_visual *vis,int start,int len,ggi_color *colormap);
typedef int (ggifunc_getpalvec)(struct ggi_visual *vis,int start,int len,ggi_color *colormap);

/* Gamma correction */
typedef int (ggifunc_getgamma)(struct ggi_visual *vis,ggi_float *r,ggi_float *g,ggi_float *b);
typedef int (ggifunc_setgamma)(struct ggi_visual *vis,ggi_float r,ggi_float g,ggi_float b);
typedef int (ggifunc_setgammamap)(struct ggi_visual *vis,int start,int len,ggi_color *gammamap);
typedef int (ggifunc_getgammamap)(struct ggi_visual *vis,int start,int len,ggi_color *gammamap);

typedef int (ggifunc_setorigin)(struct ggi_visual *vis,int x,int y);

typedef int (ggifunc_putc)(struct ggi_visual *vis,int x,int y,char c);
typedef int (ggifunc_puts)(struct ggi_visual *vis,int x,int y,const char *string);
typedef int (ggifunc_getcharsize)(struct ggi_visual *vis,int *width,int *height);

typedef int (ggifunc_fillscreen)(struct ggi_visual *vis);

typedef int (ggifunc_drawpixel_nc)(struct ggi_visual *vis,int x,int y);
typedef int (ggifunc_drawpixel)(struct ggi_visual *vis,int x,int y);
typedef int (ggifunc_putpixel_nc)(struct ggi_visual *vis,int x,int y,ggi_pixel pixel);
typedef int (ggifunc_putpixel)(struct ggi_visual *vis,int x,int y,ggi_pixel pixel);
typedef int (ggifunc_getpixel)(struct ggi_visual *vis,int x,int y,ggi_pixel *pixel);

typedef int (ggifunc_drawline)(struct ggi_visual *vis,int x,int y,int xe,int ye);

typedef int (ggifunc_drawhline_nc)(struct ggi_visual *vis,int x,int y,int w);
typedef int (ggifunc_drawhline)(struct ggi_visual *vis,int x,int y,int w);
typedef int (ggifunc_puthline)(struct ggi_visual *vis,int x,int y,int w,void *buf);
typedef int (ggifunc_gethline)(struct ggi_visual *vis,int x,int y,int w,void *buf);

typedef int (ggifunc_drawvline_nc)(struct ggi_visual *vis,int x,int y,int h);
typedef int (ggifunc_drawvline)(struct ggi_visual *vis,int x,int y,int h);
typedef int (ggifunc_putvline)(struct ggi_visual *vis,int x,int y,int h,void *buf);
typedef int (ggifunc_getvline)(struct ggi_visual *vis,int x,int y,int h,void *buf);

typedef int (ggifunc_drawbox)(struct ggi_visual *vis,int x,int y,int w,int h);
typedef int (ggifunc_putbox)(struct ggi_visual *vis,int x,int y,int w,int h,void *buf);
typedef int (ggifunc_getbox)(struct ggi_visual *vis,int x,int y,int w,int h,void *buf);

typedef int (ggifunc_copybox)(struct ggi_visual *vis,int x,int y,int w,int h,int nx,int ny);
typedef int (ggifunc_crossblit)(struct ggi_visual *src,int sx,int sy,int w,int h,
		 struct ggi_visual *dst,int dx,int dy);

typedef void (ggifunc_gcchanged)(struct ggi_visual *vis,int mask);
typedef int  (ggifunc_getapi)(struct ggi_visual *vis, int num, char *apiname, char *arguments);

typedef int (ggifunc_kgicommand)(struct ggi_visual *vis,int cmd,void *args);

#endif /* _GGI_INTERNAL_DLTYPES_H */
