/* $Id: internal.h,v 1.15 1998/10/26 12:00:29 marcus Exp $
***************************************************************************

   LibGGI internal functions and macros

   ??? Add yourself in ???
   Copyright (C) 1998	Marcus Sundberg		[marcus@ggi-project.org]
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _GGI_INTERNAL_H
#define _GGI_INTERNAL_H

#define _BUILDING_LIBGGI

#include <ggi/types.h>
#include <ggi/internal/gii.h>
#include <ggi/internal/plat.h>
#include <ggi/internal/debug.h>
#include <ggi/internal/structs.h>

/*
 * Locking functions for thread-safety
 */

#ifdef USE_THREADS

#define _ggiLockInit(mutex) \
	do { \
		(mutex).m = _ggi_malloc(sizeof(pthread_mutex_t)); \
		pthread_mutex_init((mutex).m, NULL); \
	} while (0)

#define _ggiLockDestroy(mutex) \
	do { \
		pthread_mutex_destroy((mutex).m); \
		free((mutex).m); (mutex).m=NULL; \
	} while (0)

#define _ggiLock(mutex)		pthread_mutex_lock((mutex).m)

#define _ggiUnlock(mutex)	pthread_mutex_unlock((mutex).m)

/* Returns non-zero if failed to lock. */
#define _ggiTryLock(mutex)	pthread_mutex_trylock((mutex).m)

#else	/* USE_THREADS */

#define _ggiLockInit(mutex) \
	do { \
		(mutex).i = _ggi_malloc(sizeof(int)); \
		*(mutex).i = 0; \
	} while (0)

#define _ggiLockDestroy(mutex) \
	do { \
		free((mutex).i); (mutex).i=NULL; \
	} while (0)

#define _ggiLock(mutex)	\
	while (++(*(mutex).i) != 1) { \
		 (*(mutex).i)--; _ggi_usleep(10000); \
	}

#define _ggiUnlock(mutex) \
	do { (*(mutex).i)--; } while (0)

/* Returns non-zero if failed to lock. */
static inline int _ggiTryLock(ggi_mutex mutex) {

	if (++(*mutex.i) != 1) { 
		(*mutex.i)--; 
		return -1;
	} else {
		return 0;
	}
}

#endif /* USE_THREADS */


/*
***************************************************************************
 Library internal functions and variables
***************************************************************************
*/

/* conf.c */
extern void *_ggiConfigHandle;

/* db.c */
ggi_directbuffer *_ggi_db_get_new(void);
void _ggi_db_free(ggi_directbuffer *db);
int _ggi_db_add_buffer(ggi_db_list *dbl, ggi_directbuffer *buf);
int _ggi_db_del_buffer(ggi_db_list *dbl, int idx);
int _ggi_db_move_buffer(ggi_db_list *dst, ggi_db_list *src, int idx);
ggi_directbuffer *_ggi_db_find_frame(ggi_visual *vis, int frameno);

/* dl.c */
ggi_dlhandle *_ggiOpenDL(ggi_visual *vis,const char *driver,const char *args,void *argptr);
void _ggiCloseDL(ggi_visual *vis,ggi_uint types);

ggi_dlhandle *_ggiAddDL(ggi_visual *,const char *drv,const char *args,void *argptr,int type);
void _ggiRemoveDL(ggi_visual *,ggi_dlhandle_l **lib);

/* mode.c */
void _ggiSetDefaultMode(const char *str);

/* stubs.c */
int _ggiInternFlush(ggi_visual *vis, int tryflag);
int _ggiPutPixelNC(ggi_visual *vis,int x,int y,ggi_pixel p);
int _ggiDrawPixelNC(ggi_visual *vis,int x,int y);
int _ggiDrawHLineNC(ggi_visual *vis,int x,int y,int w);
int _ggiDrawVLineNC(ggi_visual *vis,int x,int y,int h);
int _ggiSendKGICommand(ggi_visual *vis,int cmd,void *arg);

/* visual.c */
void *_ggi_malloc(size_t siz);
void *_ggi_calloc(size_t siz);
void *_ggi_realloc(void *ptr, size_t siz);
void _ggi_mem_error(void);
int _ggi_alloc_drvpriv(void);
void _ggi_free_drvpriv(int id);
void _ggiZapMode(ggi_visual *vis,ggi_uint types);

ggi_visual *_ggiNewVisual(void);
void _ggiDestroyVisual(ggi_visual *vis);


/*
***************************************************************************
 Macros to access members of LibGGI structures.
 Please use these instead of directly reference the members.
***************************************************************************
*/

#define LIBGGI_EXT(vis,extid)	(vis->extlist[(extid)].private)

#define LIBGGI_FLAGS(vis)	(vis->flags)
#define LIBGGI_FD(vis)		(vis->fd)
#define LIBGGI_SELECT_FD(vis)	(vis->select_fd)
#define LIBGGI_EVMASK(vis)	(vis->evmask)

#define LIBGGI_MODE(vis)	(vis->mode)
#define LIBGGI_PIXFMT(vis)	(vis->pixfmt)
#define LIBGGI_GC(vis)		(vis->gc)
#define LIBGGI_GC_FGCOLOR(vis)	(vis->gc->fg_color)
#define LIBGGI_GC_BGCOLOR(vis)	(vis->gc->bg_color)

#define LIBGGI_APPLIST(vis)	(vis->app_dbs)
#define LIBGGI_PRIVLIST(vis)	(vis->priv_dbs)
#define LIBGGI_APPBUFS(vis)	(LIBGGI_APPLIST(vis)->bufs)
#define LIBGGI_PRIVBUFS(vis)	(LIBGGI_PRIVLIST(vis)->bufs)
#define LIBGGI_CURREAD(vis)	(vis->r_frame->read)
#define LIBGGI_CURWRITE(vis)	(vis->w_frame->write)

#define LIBGGI_EVQUEUE(vis)	(vis->evqueue)
#define LIBGGI_DLHANDLE(vis)	(vis->dlhandle)
#define LIBGGI_PRIVATE(vis)	(vis->targetpriv)
#define LIBGGI_DRVPRIV(vis,idx)	(vis->drvpriv[(idx)])

#define LIBGGI_X(vis)		(vis->mode->visible.x)
#define LIBGGI_Y(vis)		(vis->mode->visible.y)
#define LIBGGI_VIRTX(vis)	(vis->mode->virt.x)
#define LIBGGI_VIRTY(vis)	(vis->mode->virt.y)
#define LIBGGI_GT(vis)		(vis->mode->graphtype)

#define LIBGGI_FB_SIZE(mode)	(((GT_SIZE(mode->graphtype)*mode->virt.x*mode->virt.y)+7)/8)
#define LIBGGI_FB_R_STRIDE(vis)	(vis->r_frame->buffer.plb.stride)
#define LIBGGI_FB_W_STRIDE(vis)	(vis->w_frame->buffer.plb.stride)

#define LIBGGI_R_PLAN(vis)	(vis->r_frame->buffer.plan)
#define LIBGGI_W_PLAN(vis)	(vis->w_frame->buffer.plan)


#endif /* _GGI_INTERNAL_H */
