/* 
 *  pixel drawing
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"
#include "util.h"

/*----------------------------------------------------------------------*/

#define	PUTPIXEL(OP,EXPR) \
		case GGI2D_ ## OP: ggiPutPixel(vis, x, y, EXPR); break;

void	GGIEXP(putPixel)(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel color)
{
	if (CLIP(vis, x, y)) {
		ggi_pixel	pixel;
		ggiGetPixel(vis, x, y, &pixel);
		switch (GGI2D_GC_OP(vis)) {
		case GGI2D_NOOP:	break;
		PUTPIXEL(INVERT, ~pixel )
		PUTPIXEL(SET, color )
		PUTPIXEL(SET_INVERTED, ~color )
		PUTPIXEL(AND, pixel & color )
		PUTPIXEL(NAND, ~(pixel & color) )
		PUTPIXEL(AND_REVERSE, ~pixel & color )
		PUTPIXEL(AND_INVERTED, pixel & ~color )
		PUTPIXEL(OR, pixel | color )
		PUTPIXEL(NOR, ~(pixel | color) )
		PUTPIXEL(OR_REVERSE, ~pixel | color )
		PUTPIXEL(OR_INVERTED, pixel | ~color )
		PUTPIXEL(XOR, pixel ^ color )
		PUTPIXEL(EQUIV, ~(pixel ^ color) )
		PUTPIXEL(ADD, pixel + color )
		PUTPIXEL(SUB, pixel - color )
		}
	}
}

/*----------------------------------------------------------------------*/

void	GGIEXP(drawPixel)(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{
	if (CLIP(vis, x, y)) {
		ggi_pixel	pixel, color;
		color = GGI2D_GC_DRAWCOL(vis);
		ggiGetPixel(vis, x, y, &pixel);
		switch (GGI2D_GC_OP(vis)) {
		case GGI2D_NOOP:	break;
		PUTPIXEL(INVERT, ~pixel )
		PUTPIXEL(SET, color )
		PUTPIXEL(SET_INVERTED, ~color )
		PUTPIXEL(AND, pixel & color )
		PUTPIXEL(NAND, ~(pixel & color) )
		PUTPIXEL(AND_REVERSE, ~pixel & color )
		PUTPIXEL(AND_INVERTED, pixel & ~color )
		PUTPIXEL(OR, pixel | color )
		PUTPIXEL(NOR, ~(pixel | color) )
		PUTPIXEL(OR_REVERSE, ~pixel | color )
		PUTPIXEL(OR_INVERTED, pixel | ~color )
		PUTPIXEL(XOR, pixel ^ color )
		PUTPIXEL(EQUIV, ~(pixel ^ color) )
		PUTPIXEL(ADD, pixel + color )
		PUTPIXEL(SUB, pixel - color )
		}
	}
}

void	GGIEXP(drawPixels)(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint count)
{
	int	i;
	void 	(*drawPixel)(ggi_visual_t, int, int) 
		= GGI2D_FUNC(vis)->drawPixel;
    
	for (i = 0; i < count; i++)
		drawPixel(vis, coords[i].x, coords[i].y);
}

/*----------------------------------------------------------------------*/

static void	fillPixel(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{
	if (CLIP(vis, x, y)) {
		ggi_pixel	pixel, color;
		ggiGetPixel(vis, x, y, &pixel);
		color = GGI2D_GC_FILLCOL(vis);
		switch (GGI2D_GC_OP(vis)) {
		case GGI2D_NOOP:	break;
		PUTPIXEL(INVERT, ~pixel )
		PUTPIXEL(SET, color )
		PUTPIXEL(SET_INVERTED, ~color )
		PUTPIXEL(AND, pixel & color )
		PUTPIXEL(NAND, ~(pixel & color) )
		PUTPIXEL(AND_REVERSE, ~pixel & color )
		PUTPIXEL(AND_INVERTED, pixel & ~color )
		PUTPIXEL(OR, pixel | color )
		PUTPIXEL(NOR, ~(pixel | color) )
		PUTPIXEL(OR_REVERSE, ~pixel | color )
		PUTPIXEL(OR_INVERTED, pixel | ~color )
		PUTPIXEL(XOR, pixel ^ color )
		PUTPIXEL(EQUIV, ~(pixel ^ color) )
		PUTPIXEL(ADD, pixel + color )
		PUTPIXEL(SUB, pixel - color )
		}
	}
}

static void	fillPixel_tex(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{
	if (CLIP(vis, x, y)) {
		ggi_pixel	pixel, color;
		ggiGetPixel(vis, x, y, &pixel);
		color = GGI2D_GC_FILLCOL(vis);
		switch (GGI2D_GC_OP(vis)) {
		case GGI2D_NOOP:	break;
		PUTPIXEL(INVERT, ~pixel )
		PUTPIXEL(SET, color )
		PUTPIXEL(SET_INVERTED, ~color )
		PUTPIXEL(AND, pixel & color )
		PUTPIXEL(NAND, ~(pixel & color) )
		PUTPIXEL(AND_REVERSE, ~pixel & color )
		PUTPIXEL(AND_INVERTED, pixel & ~color )
		PUTPIXEL(OR, pixel | color )
		PUTPIXEL(NOR, ~(pixel | color) )
		PUTPIXEL(OR_REVERSE, ~pixel | color )
		PUTPIXEL(OR_INVERTED, pixel | ~color )
		PUTPIXEL(XOR, pixel ^ color )
		PUTPIXEL(EQUIV, ~(pixel ^ color) )
		PUTPIXEL(ADD, pixel + color )
		PUTPIXEL(SUB, pixel - color )
		}
	}
}

void	(*GGIEXP(fillPixel)[2])(ggi_visual_t vis, ggi_sint x, ggi_sint y) =
{
	fillPixel,
	fillPixel_tex
};

/*----------------------------------------------------------------------*/

