/*
 * demo.c - (c) 1998 Thomas Tanner   tanner@ggi-project.org
 *
 * This is a demonstration of LibGGI2D's functions and can be used as a 
 * reference programming example.
 *
 * Thus it is heavily commented to explain you every single step to make
 * your own applications.
 *
 * Permission is granted to use this source as a reference for your own
 * applications. 
 *
 */

/* Include the necessary headers used for e.g. error-reporting.
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

/* Include the LibGGI declarations.
 */
#include <ggi/ggi.h>
#include <ggi/ggi2d.h>

/* The main routine.
 * It will set up a graphics mode as requested on the commandline and 
 * do an extensive test using about all graphics primitives LibGGI
 * knows.
 */
int main(int argc, char **argv)
{
	/* First we define a bunch of variables we will access throughout the
	 * main() function. Most of them are pretty meaningless loop-counters
	 * and helper-variables.
	 */
	ggi_visual_t vis;

	int i;		/* Pretty meaningless helpers used everywhere. */

	ggi_color map;	/* Yet another array of colors used for color mapping */

	/* Pixel value for white and grey. */
	ggi_pixel	white, grey, darkgrey;

	ggi_mode	mode;
	
	/* Initialize the GGI2D library. This must be called before any other 
	 * GGI2D function. Otherwise behaviour is undefined. Note that this 
	 * implicitly calls ggiInit(). No need for explicit call (won't hurt
	 * if you do).
	 */
	ggiInit();
	ggi2dInit();
	
	/* Open the default visual. This is automatically selected depending
	 * on the calling environment (Linux console, X, ...). You can 
	 * explicitly set this in the GGI_DISPLAY environment variable.
	 */
	vis=ggiOpen(NULL);
	if (vis == NULL) {
		ggiPanic("unable to open default visual, exiting.\n");
	}
	if (ggiSetGraphMode(vis, GGI_AUTO, GGI_AUTO, 
			    GGI_AUTO, GGI_AUTO , GGI_AUTO) != 0) {
		ggiPanic("Cannot set default mode!\n");
	}
	ggiGetMode(vis, &mode);
/*
	if (GT_SCHEME(mode.graphtype) == GT_PALETTE) {

		int nocols = 1 << GT_DEPTH(mode.graphtype);

		ggi_color Palette[256];

		for (i = 0; i < nocols; i++) {
			Palette[i].r = i*0xffff/(nocols-1);
			Palette[i].g = i*0xffff/(nocols-1);
			Palette[i].b = i*0xffff/(nocols-1);
		}

		ggiSetPalette(vis, 0, nocols, Palette);
	}
*/
	{
	ggi_color pal[256];
		
	for(i=0;i<256;i++)
		pal[i].r = pal[i].g = pal[i].b = i*256; 
        ggiSetPalette(vis,0,256,pal);
	}
	
	/* Find the color "white".
	 * LibGGI makes no assumptions on how a color value (which is an uint) is 
	 * actually mapped to a color on the screen. If you want to write strictly
	 * compatible programs, you need to ask LibGGI for the color value associated
	 * with a given color. We will do this now:
	 */
	map.r=0xFFFF;
	map.g=0xFFFF;
	map.b=0xFFFF;
	white=ggiMapColor(vis,&map);
	printf("white=%d\n",white);

	map.r=0xF000;
	map.g=0xF000;
	map.b=0xF000;
	grey=ggiMapColor(vis,&map);
	printf("grey=%d\n",grey);
	
	map.r=0xE000;
	map.g=0xE000;
	map.b=0xE000;
	darkgrey=ggiMapColor(vis,&map);
	printf("darkgrey=%d\n",darkgrey);
	
	/* Initialize the visual for 2D drawing */
	ggi2dOpen(vis);
	
	/* Set the drawing color to white and display some text at 0/0. 
	 */
	ggiSetGCForeground(vis,white);
	ggiPuts(vis,0,0,"Press any key to begin tests...");
#if 0	/* Activate this for clipping tests ... */
	ggiDrawHLine(vis,0,39,sx);
	ggiDrawHLine(vis,0,sy-40,sx);
	ggiDrawVLine(vis,39,0,sy);
	ggiDrawVLine(vis,sx-40,0,sy);
	ggiSetGCClipping(vis,40,40,sx-40,sy-40);
	ggi2dSetClip(vis,40,40,sx-40,sy-40);
#endif

	/* Wait for any keypress. 
	 * This is a blocking call which returns a 16 bit wide unicode character.
	 * See the comments at waitabit() for details. Do not just do things like
	 * if (ggiGetc=='y') yes();.
	 */
	ggiGetc(vis);

	ggi2dSetDrawColor(vis, white);
	ggi2dSetFillColor(vis, grey);
	ggi2dFillRect(vis, 10, 10, 40, 50);
	ggi2dSetFillColor(vis, 150);
	ggi2dTriangle(vis, 30, 40, 60, 110, 120, 25);
	ggi2dDrawCircle(vis, 100, 100, 50);
	ggi2dDrawEllipse(vis, 100, 100, 70, 40);
	ggi2dLine(vis, 10, 10, 70, 90);
	ggi2dLine(vis, 20, 10, 100, 70);
	ggi2dSetOperator(vis, GGI2D_INVERT);
	ggi2dFillRect(vis, 100, 100, 320, 200);
	ggiGetc(vis);

	/* O.K. - all done. we will now cleanly shut down LibGGI2D.
	 */

	/* First close down the visual we requested. Any further calls
	 * using vis have undefined behaviour. LibGGI is still up and 
	 * you could open another visual
	 */
	ggi2dClose(vis);
	ggiClose(vis);
	
	/* Now close down LibGGI2D. Every LibGGI2D call except ggi2dInit has 
	 * undefined behaviour now. It is not recommended to needlessly
	 * deinit-reinit LibGGI, but it should work.
	 */
	ggi2dExit();
	ggiExit();

	/* Terminate the program.
	 */
	return 0;
}
