/* $Id: gii.h,v 1.4 1998/10/24 04:04:14 marcus Exp $
***************************************************************************

   LibGII API header file
 
   This can be used as a reference for implementation.
 
   You are kindly requested, not to create incompatible spring-offs of
   LibGII. Please help us - the GGI-project - improve it instead.

***************************************************************************
*/
              
#ifndef _GGI_GII_H
#define _GGI_GII_H

#include <ggi/events.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef _BUILDING_LIBGII
typedef void *gii_input_t;
#endif

/*
***************************************************************************
 libGII function definitions
***************************************************************************
*/

/* Enter and leave the library.
 */ 
int  giiInit(void);
int  giiExit(void);

/* Open a new Input - use input `NULL' for autoselect.
 */
gii_input_t	giiOpen(const char *input,...);
int		giiClose(gii_input_t vis);

/* Get info 
 */
int		giiGetSelectFdset(gii_input_t vis, fd_set *readfds, int *haspolled);

/* Input management
 */

gii_input_t giiJoinInputs(gii_input_t inp, gii_input_t inp2);

/* Event Handling */

gii_event_mask	giiEventPoll(gii_input_t vis,gii_event_mask mask,struct timeval *t);
int 		giiEventRead(gii_input_t vis,gii_event *ev,gii_event_mask mask);
int 		giiEventSend(gii_input_t vis,gii_event *ev);
int		giiSetEventMask(gii_input_t vis, gii_event_mask evm);
gii_event_mask	giiGetEventMask(gii_input_t vis);

#define giiAddEventMask(vis,mask)  \
		giiSetEventMask((vis), giiGetEventMask(vis) | (mask))
#define giiRemoveEventMask(vis,mask)  \
		giiSetEventMask((vis), giiGetEventMask(vis) & ~(mask))

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _GGI_GII_H */
