/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: draw.c,v $
 * Revision 1.5  1998/09/02 02:21:43  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.4  1998/08/16 18:40:53  ortalo
 * A new version, STILL IN VERY ALPHA STATE... (Be patient.)
 * (However, this version is a little better... :-)
 *
 * Revision 1.3  1998/08/15 16:15:29  marcus
 * Fixed to compile with -pedantic
 *
 * Revision 1.2  1998/08/11 22:17:32  ortalo
 * Adapted to the gwt.h->ggi/gwt.h change. Incorporated the modifications
 * brought by Tristan Wibberley.
 *
 * Revision 1.1  1998/08/11 22:10:06  ortalo
 * Incorporated the changes made by Tristan Wibberley. The code is
 * still in alpha development state.
 *
 */

#include "internal.h"

/*
 * Check the return values of the standard ggi drawing functions that
 * are duplicated here?
 */

int gwtDrawPixel(gwt_window_t win, int x, int y)
{
	if (!gwtIsVisible(win)) return -1;

	x+=win->origin.x; y+=win->origin.y;
	if (gwt_region_contains_point(win->visible, x, y))
		return ggiDrawPixel(win->visual, x, y);
	return 0;
}

int gwtPutPixel(gwt_window_t win, int x, int y, ggi_pixel pixel)
{
	if (!gwtIsVisible(win)) return -1;

	x+=win->origin.x; y+=win->origin.y;
	if (gwt_region_contains_point(win->visible, x, y))
		return ggiPutPixel(win->visual, x, y, pixel);
	return 0;
}

int gwtDrawFrame(gwt_window_t win)
{
	ggi_coord tl, br;

	if (!gwtIsVisible(win)) return -1;
	gwt_region_bounds(win->geometry, &tl, &br);
	ggiDrawHLine(win->visual, tl.x,   tl.y,   br.x-tl.x);
	ggiDrawHLine(win->visual, tl.x,   br.y-1, br.x-tl.x);
	ggiDrawVLine(win->visual, tl.x,   tl.y,   br.y-tl.y);
	ggiDrawVLine(win->visual, br.x-1, tl.y,   br.y-tl.y);
	return 0;
}

/* These next two functions can be altered to operate on the invalid
 * region instead of the visible one. Just change win->visible to
 * win->invalid :)
 */

int gwtDrawRect(gwt_window_t win)
{
	int rectno=0;
	ggi_coord tl, br;

	if (!gwtIsVisible(win)) return -1;
	while (gwt_region_rect(win->visible, rectno++, &tl, &br)) {
		ggiDrawHLine(win->visual, tl.x,   tl.y,   br.x-tl.x);
		ggiDrawHLine(win->visual, tl.x,   br.y-1, br.x-tl.x);
		ggiDrawVLine(win->visual, tl.x,   tl.y,   br.y-tl.y);
		ggiDrawVLine(win->visual, br.x-1, tl.y,   br.y-tl.y);
	}
	return 0;
}

int gwtFillscreen(gwt_window_t win)
{
	int rectno=0;
	ggi_coord tl, br;

	if (!gwtIsVisible(win)) return -1;
	while (gwt_region_rect(win->visible, rectno++, &tl, &br))
		ggiDrawBox(win->visual, tl.x, tl.y, br.x-tl.x, br.y-tl.y);
	return 0;
}

int gwtCopyBox(gwt_window_t win, int x, int y, int w, int h, int nx, int ny)
{
	gwt_region_t box, boxint;
	ggi_coord tl, br;
	int rectno=0;

	if (!gwtIsVisible(win)) return -1;
	gwt_region_create(&box);
	gwt_region_create(&boxint);
	gwt_region_init(box, x+win->origin.x, y+win->origin.y, x+w+win->origin.x, y+h+win->origin.y);
	gwt_region_copy(boxint, win->visible);
	gwt_region_intersection(boxint, box);
	while (gwt_region_rect(win->visible, rectno++, &tl, &br))
		ggiCopyBox(win->visual, tl.x, tl.y, br.x-tl.x, br.y-tl.y, nx+win->origin.x, ny+win->origin.y);
	return 0;
}

int gwt_copy_displayed_region(ggi_visual_t vis, gwt_region_t region, int dx, int dy)
{
	ggi_coord tl, br;
	int rectno=0;
	while (gwt_region_rect(region, rectno++, &tl, &br))
		ggiCopyBox(vis, tl.x, tl.y, br.x-tl.x, br.y-tl.y, tl.x+dx, tl.y+dy);
	return 0;
}
