/* $Id: tt_region.h,v 1.2 1998/08/09 01:00:11 tanner Exp $ */
/* 
 *  Rectangle and region functions
 *
 *  Copyright (C) 1998 by Thomas Tanner. 
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef	_TT_REGION_H_
#define	_TT_REGION_H_

/*************************************************************************/

typedef struct {
	int	left;
	int	top;
	int	right;
	int	bottom;
} rect_t;

extern	rect_t	emptyRect;

typedef struct {
	unsigned size;
	unsigned limit;
	rect_t	*rect;
} region_t;

/*************************************************************************/

void	rectAssign(rect_t *r, int x1, int y1, int x2, int y2);
void	rectCopy(rect_t *dest, rect_t *src);
int	rectEmpty(rect_t *r);
int	rectArea(rect_t *r);
int	rectEqual(rect_t *a, rect_t *b);
int	rectCompare(rect_t *a, rect_t *b);
int	rectContainsPoint(rect_t *r, int x, int y);
int	rectContains(rect_t *r, rect_t *sub);
int	rectIntersects(rect_t *r, rect_t *other);
void	rectMove(rect_t *r, int dx, int dy);
void	rectMoveTo(rect_t *r, int left, int top);
int	rectResize(rect_t *r, int dx, int dy);
int	rectIntersect(rect_t *r1, rect_t *r2, rect_t *result);
void	rectUnion(rect_t *r1, rect_t *r2, rect_t *result);

int	regionInit(region_t *r, unsigned limit);
void	regionFree(region_t *r);
int	regionAdjustSize(region_t *r);
int	regionCopy(region_t *dest, region_t *src);
int	regionEmpty(region_t *r);
int	regionArea(region_t *r);
int	regionEqual(region_t *r1, region_t *r2);
int	regionCompare(region_t *r1, region_t *r2);
void	regionBoundingBox(region_t *r, rect_t *bbox);
int	regionContainsPoint(region_t *r, int x, int y);
int	regionContainsRect(region_t *r, rect_t *rect);
int	regionContains(region_t *r, region_t *sub);
int	regionIntersectsRect(region_t *r, rect_t *rect);
int	regionIntersects(region_t *r, region_t *other);
void	regionMove(region_t *r, int dx, int dy);
void	regionAddRect(region_t *r, rect_t *rect);
void	regionAdd(region_t *r, region_t *other);
int	regionIntersectRect(region_t *r, rect_t *other);
int	regionIntersect(region_t *r, region_t *other);
int	regionSubtractRect(region_t *r, rect_t *other);
int	regionSubtract(region_t *r, region_t *other);

/*************************************************************************/

#endif	/* _TT_REGION_H */
