/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1997 Uwe Maurer - uwe_maurer@t-online.de
 *                    Andreas Beck - becka@ggi-project.org
 *               1998 Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: init.c,v $
 * Revision 1.3  1998/08/15 16:15:30  marcus
 * Fixed to compile with -pedantic
 *
 * Revision 1.2  1998/08/11 22:10:08  ortalo
 * Incorporated the changes made by Tristan Wibberley. The code is
 * still in alpha development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#include "internal.h"
#include <string.h>

/*
 *
 *   Initialisation segment of libgwt
 *
 */

/*
 * Internal structures of initialisation of library
 */
static int _gwtIsUp = 0; /* starter flag */
ggi_extid gwtID = -1; /* ext. ID (default to -1 should segfault easily) */

/*
 * Change notification mechanism
 */
static int changed(ggi_visual_t vis, int whatchanged)
{
  DPRINT("GWT: changed called - vis=%p, what=%i\n",
	 vis,whatchanged);

  switch (whatchanged) {
  case GGI_CHG_APILIST:
    {
      int temp;
      char api[256], args[256];
      for (temp=0; 0==ggiGetAPI(vis,temp,api,args); temp++) {
	strcat(api, "-gwt");
	DPRINT("GWT: would now load #%d: %s(%s)\n",temp,api,args);
      }
    }
  break;
  }
  return 0;
}

/*
 * Initialisation function
 *  REQUIRES: _gwtIsUp be initialised to 0.
 */
int gwtInit(void)
{
  _gwtIsUp++;
  if (_gwtIsUp!=1) return 0; /* Init. only on first call */

  ggiInit();
  gwtID = ggiExtensionRegister("GWT", sizeof(gwtprivate), changed);

  DPRINT("GWT: Real initialisation\n");

  return (gwtID >= 0) ? 0 : -1;
}

/*
 * Exit function
 */
int gwtExit(void)
{
  int ret;

  if (_gwtIsUp <= 0) return -1; /* Error: nothing initialised yet */

  _gwtIsUp--;

  if (_gwtIsUp != 0) return 0; /* Exit really only on last call */

  ret = ggiExtensionUnregister(gwtID);
  ggiExit();

  DPRINT("GWT: Final real exit\n");

  return ret;
}

int gwtAttach(ggi_visual_t vis)
{
	int ret;
	DPRINT("GWT: Preattached to %p.\n", vis);
	ret=ggiExtensionAttach(vis, gwtID);
	DPRINT("GWT: Attached to %p. ret=%i\n", vis, ret);

	if (ret==0) { /* We are actually creating the primary instance */
		/* assign initial LIBGGI_EXT(vis, gwtID) private data */
	  /* This seems to cause a segfault under the debugger ? -- ortalo
		strcpy(LIBGGI_EXT(vis, gwtID), "GWT Private Data !");
	  */
		/* Now fake an "API change" so the right libs get loaded */
		changed(vis, GGI_CHG_APILIST);
	}

	return ret;
}

int gwtDetach(ggi_visual_t vis)
{
	int ret;
	ret=ggiExtensionDetach(vis, gwtID);
	DPRINT("GWT: Detached from %p. ret=%i\n", vis, ret);

	return ret;
}
