/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: window.c,v $
 * Revision 1.5  1998/09/02 02:21:49  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.4  1998/08/23 18:57:15  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.3  1998/08/16 18:40:58  ortalo
 * A new version, STILL IN VERY ALPHA STATE... (Be patient.)
 * (However, this version is a little better... :-)
 *
 * Revision 1.2  1998/08/11 22:10:11  ortalo
 * Incorporated the changes made by Tristan Wibberley. The code is
 * still in alpha development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#include <malloc.h>
#include "internal.h"

/* TODO: Threadsafety */

/*******************************************************************
 *                      STATIC FUNCTIONS                           *
 *******************************************************************/

/*
 * Window data type creation
 */
static int new_window(gwt_window_t *win) {

	(*win) = (gwt_window_t)malloc(sizeof(gwt_window));
	gwt_zinit_window(*win);

	gwt_region_create(&(*win)->geometry);
	gwt_region_create(&(*win)->_family_visible);
	gwt_region_create(&(*win)->_external_visible);
	gwt_region_create(&(*win)->visible);
	gwt_region_create(&(*win)->invalid);
#if 0
	(*win)->id = gwt_allocate_id();
	gwt_associate_id((*win)->id, *win);
#endif
	(*win)->priv = NULL;
	return 0;
}

/*
 * Window data type destruction
 */
static int delete_window(gwt_window_t win) {
	gwt_region_destroy(win->geometry);
	gwt_region_destroy(win->_family_visible);
	gwt_region_destroy(win->_external_visible);
	gwt_region_destroy(win->visible);
	gwt_region_destroy(win->invalid);
#if 0
	gwt_free_id(win->id);
#endif
	free(win);
	return 0;
}

/*******************************************************************
 *                 GWT PUBLIC EXPORTED FUNCTIONS                   *
 *******************************************************************/

/*
 * Root window creation/attachment
 */
int gwtCreateRootWindow(ggi_visual_t vis, gwt_window_t *win) {
	new_window(win);
	(*win)->level = 0;
	(*win)->visual = vis;
	(*win)->wparent = NULL;
	(*win)->hidden = 0;
	(*win)->_implicit_hide = 0;

	gwt_region_init((*win)->geometry, 0, 0, LIBGGI_MODE(vis)->visible.x,
						LIBGGI_MODE(vis)->visible.y);
	gwt_region_copy((*win)->_external_visible, (*win)->geometry);
	gwt_region_copy((*win)->_family_visible, (*win)->_external_visible);
	gwt_region_copy((*win)->visible, (*win)->_external_visible);
	gwt_region_copy((*win)->invalid, (*win)->_external_visible);

	(*win)->origin.x = 0;
	(*win)->origin.y = 0;

	DPRINT("GWT: Opened root window - win=%p\n", win);

	return 0;
}

/*
 * Root window termination
 */
/* TODO: Handle detachment from visual (I don't think there is anything TODO -- Tristan) */

/*
 * Creation of one sub window
 */
int gwtCreateWindow(gwt_window_t parent, gwt_window_t *win) {
	new_window(win);
	(*win)->level = parent->level + 1;
	(*win)->hidden = 1;
	(*win)->_implicit_hide = parent->_implicit_hide || parent->hidden;
	(*win)->visual = parent->visual;

	/* Set Geometry to that of its parent */
	gwt_region_copy((*win)->geometry, parent->geometry);
	gwt_region_init((*win)->_external_visible, 0, 0, 0, 0);
	gwt_region_copy((*win)->_family_visible, (*win)->_external_visible);
	gwt_region_copy((*win)->visible, (*win)->_external_visible);
	gwt_region_copy((*win)->invalid, (*win)->_external_visible);

	DPRINT("GWT: About to insert child window\n");
	gwt_reparent((*win), parent);	/* this should put the child at the top */
	DPRINT("GWT: Inserted child window\n");
	DPRINT("GWT: Opened sub window - win=%p\n", (*win));
	return 0;
}

/*
 * Destruction of a window
 */
static int _gwt_destroy1(gwt_window_t win) {
  gwt_window_t child, nextchild;
  /* TODO: destroy children, invalidate uncovered regions */
  /* Destroy starting from back */
  child = GWT_Z_BOTTOM_CHILD(win);
  while ( child != NULL ) {
    nextchild=GWT_Z_UP(child); /* do this first because gwt_zextract will NULL it */
    gwt_zextract(child); /* Remove from zorder */
    _gwt_destroy1(child); /* Recursive destruction */
    child = nextchild;
  }
  DPRINT("GWT: Closing window - win=%p\n", win);
  return delete_window(win);
}

int gwtDestroy(gwt_window_t win) {
	int ret;

	if ( win->level > 0 ) {
		gwtHide(win);
		gwt_zextract(win);
	}
	ret = _gwt_destroy1(win); /* NB: Don't recurse within a lock... */
	
	DPRINT("GWT: Closed window - win=%p\n", win);
	
	return ret;
}

/*
 * Window visual access
 */
int gwtGetVisual(gwt_window_t win, ggi_visual_t *vis) {
	(*vis) = win->visual;
	return 0;
}

/*******************************************************************
 *                  GWT PRIVATE EXPORTED FUNCTIONS                 *
 *******************************************************************/

/*
 * Global lock/unlock functions for the library
 */
 /* TODO: locking */
