#include "obgtkBox.h"

@implementation Gtk_Box
- castGtkBox:(GtkBox *) castitem
{
  self = [super castGtkContainer:GTK_CONTAINER(castitem)];
  gtkbox = castitem;
  return self;
}

- pack_start:(Gtk_Widget *) child
    doExpand:(gint) expand
      doFill:(gint) fill
   doPadding:(gint) padding
{
  gtk_box_pack_start(gtkbox, child->gtkwidget, expand, fill, padding);
  return self;
}

- pack_end:(Gtk_Widget *) child
    doExpand:(gint) expand
      doFill:(gint) fill
   doPadding:(gint) padding
{
  gtk_box_pack_end(gtkbox, child->gtkwidget, expand, fill, padding);
  return self;  
}

- pack_start_defaults:(Gtk_Widget *) child
{
  gtk_box_pack_start_defaults(gtkbox, child->gtkwidget);
  return self;
}

- pack_end_defaults:(Gtk_Widget *) child
{
  gtk_box_pack_end_defaults(gtkbox, child->gtkwidget);
  return self;
}

- set_homogeneous:(gint) homogeneous
{
  gtk_box_set_homogeneous(gtkbox, homogeneous);
  return self;
}

- set_spacing:(gint) spacing
{
  gtk_box_set_spacing(gtkbox, spacing);
  return self;
}

- reorder_child  :(id) child
 newChildPosition:(guint) pos
{
  gtk_box_reorder_child(gtkbox,
			GTK_WIDGET([child getGtkObject]),
			pos);
  return self;
}

- query_child_packing:(id) child
	    getExpand:(gint *) expand
	      getFill:(gint *) fill
	   getPadding:(gint *) padding
	  getPackType:(GtkPackType *) pack_type
{
  gtk_box_query_child_packing(gtkbox, GTK_WIDGET([child getGtkObject]),
			      expand, fill, padding, pack_type);
  return self;
}

- set_child_packing:(id) child
	  setExpand:(gint) expand
	    setFill:(gint) fill
	 setPadding:(gint) padding
	setPackType:(GtkPackType) pack_type
{
  gtk_box_set_child_packing(gtkbox, GTK_WIDGET([child getGtkObject]),
			    expand, fill, padding, pack_type);
  return self;
}
@end
