#include "obgtkTree.h"
#include "obgtkTreeItem.h"
#include <gtk/gtktreeitem.h>

@implementation Gtk_Tree
- init
{
  return [self castGtkTree:GTK_TREE(gtk_tree_new())];
}

- appendTreeItem:(id) child
{
  gtk_tree_append(gtktree, GTK_WIDGET([child getGtkObject]));
  return self;
}

- prependTreeItem:(id) child
{
  gtk_tree_prepend(gtktree, GTK_WIDGET([child getGtkObject]));
  return self;
}

- insertTreeItem:(id) child
        childPos:(gint) position
{
  gtk_tree_insert(gtktree, GTK_WIDGET([child getGtkObject]), position);
  return self;
}

- castGtkTree:(GtkTree *) castitem
{
  gtktree = castitem;
  return [super castGtkContainer:GTK_CONTAINER(castitem)];
}

- remove_items:(GList *) items
{
  gtk_tree_remove_items(gtktree, items);
  return self;
}

- clear_items:(gint) start :(gint) end
{
  gtk_tree_clear_items(gtktree, start, end);
  return self;
}

- select_item:(gint) item
{
  gtk_tree_select_item(gtktree, item);
  return self;
}

- unselect_item:(gint) item
{
  gtk_tree_unselect_item(gtktree, item);
  return self;
}

- select_child:(id) gtk_treeitem
{
  gtk_tree_select_child(gtktree, GTK_WIDGET([gtk_treeitem getGtkObject]));
  return self;
}

- unselect_child:(id) gtk_treeitem
{
  gtk_tree_select_child(gtktree, GTK_WIDGET([gtk_treeitem getGtkObject]));
  return self;
}

- (gint)child_position:(id) gtk_treeitem
{
  return gtk_tree_child_position(gtktree, GTK_WIDGET([gtk_treeitem getGtkObject]));
}

- set_selection_mode:(GtkSelectionMode) mode
{
  gtk_tree_set_selection_mode(gtktree, mode);
  return self;
}

- set_view_mode:(GtkTreeViewMode) mode
{
  gtk_tree_set_view_mode(gtktree, mode);
  return self;
}

- set_view_lines:(guint) flag
{
  gtk_tree_set_view_lines(gtktree, flag);
  return self;
}
@end
