/**
 *
 * $Id: Obso1_2.c,v 1.3 1998/09/24 15:37:38 pgw Exp $
 *
 * Copyright (C) 1997 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static const char rcsid[] = "$Id: Obso1_2.c,v 1.3 1998/09/24 15:37:38 pgw Exp $";

#include <LTconfig.h>
#include <Xm/DrawP.h>
#include <XmI/ShadowI.h>

/* This file contains functions from previous versions that are now obsolete */

void
_XmClearBorder(Display *display,
               Window win,
               Position x,
               Position y,
               Dimension width,
               Dimension height,
               Dimension shadow_thick)
{
   XmeClearBorder(display, win, x, y, width, height, shadow_thick);
}

void
_XmDrawArrow(Display *display,
             Window win,
             GC topGC,
             GC bottomGC,
             GC fillGC,
             Position x, Position y,
             Dimension width, Dimension height,
             Dimension shadowThickness,
             unsigned char direction)
{
   XmeDrawArrow(display, win, bottomGC, topGC, fillGC,
                x, y, width, height, shadowThickness, direction);
}

void
_XmDrawDiamond(Display *display,
               Window win,
               GC bottomGC,
               GC topGC,
               GC selectGC,
               Position x, Position y,
               Dimension width, Dimension height,
               Dimension shadowThickness,
               Dimension fill)
{
   XmeDrawDiamond(display, win, bottomGC, topGC, selectGC, x, y, width, height,
                  shadowThickness, fill);
}


void
_XmDrawSeparator(Display *display,
                 Drawable win,
                 GC top_gc,
                 GC bottom_gc,
                 GC separator_GC,
                 Position wx,
                 Position wy,
                 Dimension wwidth,
                 Dimension wheight,
                 Dimension shadowThickness,
                 Dimension margin,
                 unsigned char orientation,
                 unsigned char separator_type)
{
   XmeDrawSeparator(display, win, top_gc, bottom_gc, separator_GC,
                    wx, wy, wwidth, wheight, shadowThickness, margin,
                    orientation, separator_type);
}

void
_XmDrawShadow(Display *display,
              Drawable d,
              GC top_gc,
              GC bottom_gc,
              Dimension shad_thick,
              Position x,
              Position y,
              Dimension width,
              Dimension height)
{
    _XmDrawShadows(display, d,
                   top_gc, bottom_gc,
                   x, y,
                   width, height,
                   shad_thick, XmSHADOW_OUT);
}

void
_XmDrawShadows(Display *display,
               Window win,
               GC topShadowGC,
               GC bottomShadowGC,
               Position x, Position y,
               Dimension width, Dimension height,
               Dimension shadowThickness,
               unsigned int shadowType)
{
   XmeDrawShadows(display, win, topShadowGC, bottomShadowGC, x, y,
                  width, height, shadowThickness, shadowType);
}

void
_XmDrawSimpleHighlight(Display *display,
                       Drawable d,
                       GC gc,
                       Position x,
                       Position y,
                       Dimension width,
                       Dimension height,
                       Dimension highlight_thick)
{
   XmeDrawHighlight(display, d, gc, x, y, width, height, highlight_thick);
}

/*
 * Undocumented but present since the early days.
 * XmDiary is an example of their use.
 *
 * Looks like they just call the methods ...
 */
void
_XmHighlightBorder(Widget w)
{
    /* using _XmHighlightBorder in ShadowI.c */
   _XmHighlightBorder_1_2_(w);
}

void
_XmUnhighlightBorder(Widget w)
{
   /* using _XmUnhighlightBorder in ShadowI.c */
   _XmUnhighlightBorder_1_2_(w);
}

