/*   gpattern.h
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* File Name:  gpattern.h
*
* Author:  Epstein
*
* Version Creation Date:   1/4/94
*
* $Revision: 6.0 $
*
* File Description:
*       Generic pattern matching
*
* Modifications:
* --------------------------------------------------------------------------
* Date     Name        Description of modification
* -------  ----------  -----------------------------------------------------
*
* $Log: gpattern.h,v $
* Revision 6.0  1997/08/25 18:53:20  madden
* Revision changed to 6.0
*
* Revision 1.3  1997/01/28 20:45:35  epstein
* add C++ directives
*
 * Revision 1.2  1996/06/21  14:10:52  epstein
 * add boilerplate and run 'indent'
 *
*
* ==========================================================================
*/

#include <regex.h>

#ifndef _GPATTERN_H_
#define _GPATTERN_H_

#ifdef __cplusplus
extern "C" {
#endif


typedef VoidPtr CompiledPattern;

/* for internal use only */
struct patstuff {
    struct re_pattern_buffer patbuf;
    struct re_registers regs;
};


/* returns a compiled pattern given a SED-style regular expression */
CompiledPattern LIBCALL CompilePattern (CharPtr pattern);

void LIBCALL    FreeCompiledPattern (CompiledPattern compPat);

#ifdef __cplusplus
}
#endif

#endif				/* _GPATTERN_H_ */
