#ifndef _URKTREE__
#define _URKTREE__

#include <ncbi.h>

#ifdef __cplusplus
extern "C" {
#endif

#define TREE_NULL     0
#define TREE_ROOTED   1
#define TREE_UNROOTED 2

typedef struct GeneTreeNode
{
  CharPtr  name;
  FloatHi  score;
  Boolean  flagPivot;
  Int4     level, nodenumber;
  struct GeneTreeNode PNTR ptrLeft, PNTR ptrRight, PNTR ptrUp;
} TreeNode, PNTR TreeNodePtr;

extern TreeNodePtr TreeCenterNode (TreeNodePtr ptrNode);
extern TreeNodePtr ExploreUnrootedTree (TreeNodePtr ptrNode,
                                        TreeNodePtr ptrSkip,
                                        Int4 nodenumber);
extern TreeNodePtr ExploreUnrootedTreeNumber (TreeNodePtr ptrNode,
                                              Int4 nodenumber);

extern Int4 GetDeepestLevelBranch (TreeNodePtr ptrNode, Int4 level);
extern void SetLevelNode (TreeNodePtr ptrNode, Int4 level);
extern TreeNodePtr ExploreTreeLevel (TreeNodePtr ptrNode, Int4 level,
                                     TreeNodePtr ptrSkip);

extern void SetZeroNode (TreeNodePtr ptrNode);
extern Int4 SetNumberNode (TreeNodePtr ptrNode, Int4 nodenumber);
extern TreeNodePtr HeadNode (TreeNodePtr ptrNode);
extern TreeNodePtr LastNode (TreeNodePtr ptrNode);
extern TreeNodePtr ExploreTreeNumber (TreeNodePtr ptrNode,
                                      Int4 nodenumber);

extern TreeNodePtr FindPivotNode (TreeNodePtr ptrNode,
                                  TreeNodePtr ptrSkip);
extern void UnSetPivotNode (TreeNodePtr ptrNode);
extern TreeNodePtr SetPivotNode (TreeNodePtr ptrNode, Int4 level);
extern TreeNodePtr SetAllPivotNodes (TreeNodePtr ptrNode);

extern Int4 TestTree (TreeNodePtr ptrNode);
extern TreeNodePtr RootTree (TreeNodePtr ptrNode,
                             Int4 left, Int4 right);
extern TreeNodePtr UnrootTree (TreeNodePtr ptrNode);

extern TreeNodePtr TreeNodeNew (void);
extern TreeNodePtr TreeNodeFree (TreeNodePtr ptrNode);
extern TreeNodePtr TreeNodeFreeBranch (TreeNodePtr ptrNode);
extern TreeNodePtr TreeNodeFreeTree (TreeNodePtr ptrNode);

#ifdef __cplusplus
}
#endif

#endif
