/*
 * _VF.h 
 *
 *  Programmmed by Hirotsugu Kakugawa, Hiroshima University
 *  E-Mail:  h.kakugawa@computer.org
 *
 *  Edition History
 *  28 Dec 1993  Added VF_GetOutline().
 *  19 Jan 1994  Added font class "VF_FONT_TT". (by I. Matsuda)
 *  20 Jan 1994  Added VF_GetOutline2().
 *  15 May 1995  Added VFFM_*().
 *  18 Nov 1995  Added Null font class.
 *  21 Nov 1995  Added BDF font class.
 *  19 Feb 1996  Added GetCharSet() and GetEnc() to FontObj structure. (WL)
 *   1 Apr 1996  Added HBF font class. (WL)
 */


/* This file is part of VFlib
 *
 * Copyright (C) 1993-1998 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * This file is part of the VFlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __VFLIB__VF_H__

#define __VFLIB__VF_H__

/* Font Class ID */
#define  VF_FONT_NULL         0
#define  VF_FONT_SONY         1
#define  VF_FONT_ZEIT         2
#define  VF_FONT_JG           3
#define  VF_FONT_TT           4
#define  VF_FONT_BDF          5
#define  VF_FONT_HBF          6
#define  VF_FONT_FONTWAVE     7
#define  VF_FONT_FREETYPE     8
#define  VF_FONT_COMPOUND    20
#define  VF_FONT_BITOP       21
#define  VF_FONT_NULLFONT    22

/* temporary use */
#define  VF_FONT_COMPOUND2   23

/*---------------------------------------------------*/

#define TRUE  (0==0)
#define FALSE (0==1)

#define  Public   /**/
#define  Const    /**/
#define  Private  static
#define  Import   extern

typedef  long       FILE_Port;  
#define  NULL_PORT  (-1)


/* Font Object Structure */
struct s_font_obj {
  /* Class ID */
  int                 ClassID;
  /* Itself */
  struct s_font_obj  *Self;
  /* The number of Objects that share this object */
  int                LinkCount;
  /* Methods */
  int                (*OpenFont)();
  int                (*CloseFont)();
  int                (*GetBitmap)();
  long*              (*GetOutline)();
  long*              (*GetOutline2)();
  int                (*DrawOutline)();
  int                (*FreeOutline)();
  int                (*Link)();
  int                (*Unlink)();
  int                (*GetCharSet)();
  int                (*GetEnc)();
  /* Class Dependent Local Data */
  long               Locals; 
};
typedef struct s_font_obj   FontObj;


/* Font Class Table */
struct s_font_class_table {
  char    *ClassName;
  int     FontClass;
  FontObj *(*ObjCreater)();
};
typedef struct s_font_class_table  FontClassTable;


/* Font Table */
struct s_font_table {
  FontObj  *Fobj;   /* Font Object */
  char     *Fentry; /* Font Entry Name */
  char     *Fname;  /* Font Name */
};
typedef struct s_font_table  FontTable;


struct s_fm_tbl {
  int     opened;
  union {
    FILE    *stream;
    int     fd;
  } uu;
  char    *path;
  int    (*open_fun)();
  int    (*close_fun)();
};
typedef struct s_fm_tbl  fm_tbl;


int  VF_LinkFont();
int  VF_UnlinkFont();

char *VF_Fontname2Entry();

int         VFFM_Init();
int         VFFM_Deinit();
FILE_Port   VFFM_Intern();
FILE_Port   VFFM_InternInt();
FILE*       VFFM_FStream();
int         VFFM_FInt();
int         VFFM_UnIntern();


#endif /* __VFLIB__VF_H__ */

