/*								-*- C++ -*-
 * $Id: WIN_windowdraw.cpp,v 1.4 1997-01-15 14:59:30+01 mho Exp $
 *
 * Purpose: device context methods for wxWindow (included as is from Window.cpp)
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

//-----------------------------------------------------------------------------
// create and destroy associated device context
//-----------------------------------------------------------------------------

wxWindowDC* wxWindow::CreateDC(void)
{
    if (dc) return dc; // only create once!

    dc = wxNEW wxWindowDC;
    // Initialize wxWindowDC
    dc->Initialize(wxAPP_DISPLAY, wxAPP_SCREEN, 0); // drawable initialized on
						    // first expose event
    // adjust background colour
    wxBrush bgbrush(bg, wxSOLID);  // I need a temporary background brush
    dc->SetBackground(&bgbrush);   // set GCs to current background colour
    dc->SetBackground(NULL);       // don't use a background brush
    // return device context
    return dc;
}

void wxWindow::DestroyDC(void)
{
    if (!dc) return; // no DC to destroy
    // destroy device context
    delete dc;
    dc = NULL;
}

wxWindowDC* wxWindow::GetDC(void)
{
    // if no device context present, create one
    if (dc)
	return dc;
    return CreateDC();
}

//-----------------------------------------------------------------------------
// methods of the associated device context
//-----------------------------------------------------------------------------

void wxWindow::AutoSetTools(Bool set_auto)
{
    if (dc) dc->AutoSetTools(set_auto);
}

void wxWindow::BeginDrawing(void)
{
    if (dc) dc->BeginDrawing();
}

Bool wxWindow::Blit(float xdest, float ydest, float w, float h, wxDC *src, float xsrc,
		    float ysrc, int rop)
{
    if (dc) return dc->Blit(xdest, ydest, w, h, src, xsrc, ysrc, rop);
    return FALSE;
}

void wxWindow::Clear(void)
{
    if (dc) dc->Clear();
}

void wxWindow::CrossHair(float x, float y)
{
    if (dc) dc->CrossHair(x, y);
}

void wxWindow::DestroyClippingRegion(void)
{
    if (dc) dc->DestroyClippingRegion();
}

float wxWindow::DeviceToLogicalX(int x)
{
    if (dc) return dc->DeviceToLogicalX(x);
    return float(x);
}

float wxWindow::DeviceToLogicalXRel(int x)
{
    if (dc) return dc->DeviceToLogicalXRel(x);
    return float(x);
}

float wxWindow::DeviceToLogicalY(int y)
{
    if (dc) return dc->DeviceToLogicalY(y);
    return float(y);
}

float wxWindow::DeviceToLogicalYRel(int y)
{
    if (dc) return dc->DeviceToLogicalYRel(y);
    return float(y);
}

void wxWindow::DrawArc(float x1, float y1, float x2, float y2, float xc, float yc)
{
    if (dc) dc->DrawArc(x1, y1, x2, y2, xc, yc);
}

void wxWindow::DrawBitmap8(unsigned char *data, int w, int h,
			   wxColourMap *cmap, float x, float y)
{
    if (dc) dc->DrawBitmap8(data, w, h, cmap, x, y);
}

void wxWindow::DrawEllipse(float x, float y, float w, float h)
{
    if (dc) dc->DrawEllipse(x, y, w, h);
}

void wxWindow::DrawIcon(wxBitmap *icon, float x, float y, Bool useMask)
{
    if (dc) dc->DrawIcon(icon, x, y, useMask);
}

void wxWindow::DrawLine(float x1, float y1, float x2, float y2)
{
    if (dc) dc->DrawLine(x1, y1, x2, y2);
}

void wxWindow::DrawLines(int n, wxPoint pts[], float xoff, float yoff)
{
    if (dc) dc->DrawLines(n, pts, xoff, yoff);
}

void wxWindow::DrawLines(int n, wxIntPoint pts[], int xoff, int yoff)
{
    if (dc) dc->DrawLines(n, pts, xoff, yoff);
}

void wxWindow::DrawLines(wxList *pts, float xoff, float yoff)
{
    if (dc) dc->DrawLines(pts, xoff, yoff);
}

void wxWindow::DrawPoint(float x, float y)
{
    if (dc) dc->DrawPoint(x, y);
}

void wxWindow::DrawPolygon(int n, wxPoint pts[], float xoff, float yoff, int fill)
{
    if (dc) dc->DrawPolygon(n, pts, xoff, yoff, fill);
}
	
void wxWindow::DrawPolygon(wxList *pts, float xoff, float yoff, int fill)
{
    if (dc) dc->DrawPolygon(pts, xoff, yoff, fill);
}

void wxWindow::DrawRectangle(float x, float y, float w, float h)
{
    if (dc) dc->DrawRectangle(x, y, w, h);
}

void wxWindow::DrawRoundedRectangle(float x, float y, float w, float h, float radius)
{
    if (dc) dc->DrawRoundedRectangle(x, y, w, h, radius);
}

#if USE_SPLINES

void wxWindow::DrawSpline(float x1,float y1, float x2,float y2, float x3,float y3)
{
    if (dc) dc->DrawSpline(x1, y1, x2, y2, x3, y3);
}

void wxWindow::DrawSpline(int n, wxPoint pts[])
{
    if (dc) dc->DrawSpline(n, pts);
}

void wxWindow::DrawSpline(wxList *pts)
{
    if (dc) dc->DrawSpline(pts);
}

#endif

void wxWindow::DrawText(const char *text, float x, float y, Bool use16Bit)
{
    if (dc) dc->DrawText(text, x, y, use16Bit);
}

void wxWindow::EndDrawing(void)
{
    if (dc) dc->EndDrawing();
}

void wxWindow::FloodFill(float x, float y, wxColour *col, int style)
{
    if (dc) dc->FloodFill(x, y, col, style);
}

wxBrush* wxWindow::GetBackground(void)
{
    if (dc) return dc->GetBackground();
    return (NULL);
}

wxBrush* wxWindow::GetBrush(void)
{
    if (dc) return dc->GetBrush();
    return (NULL);
}

float wxWindow::GetCharHeight(void)
{
    if (dc) return dc->GetCharHeight();

    int dummy; XCharStruct overall;
    XTextExtents(font.GetInternalFont(), "x", 1, &dummy, &dummy, &dummy, &overall);
    return (float)(overall.ascent+overall.descent);
}

float wxWindow::GetCharWidth(void)
{
    if (dc) return dc->GetCharWidth();

    int dummy; XCharStruct overall;
    XTextExtents(font.GetInternalFont(), "x", 1, &dummy, &dummy, &dummy, &overall);
    return (float)(overall.width);
}

void wxWindow::GetClippingRegion(float *x, float *y, float *w, float *h)
{
    if (dc) 
        dc->GetClippingRegion(x, y, w, h);
    else {
        *x = *y = 0;
        *w = *h = -1;
    }
}

wxFont* wxWindow::GetFont(void)
{
    if (dc) return dc->GetFont();
    return (&font);
}

int wxWindow::GetLogicalFunction(void)
{
    if (dc) return dc->GetLogicalFunction();
    return (0);
}

int wxWindow::GetMapMode(void)
{
    if (dc) return dc->GetMapMode();
    return (0);
}

Bool wxWindow::GetOptimization(void)
{
    if (dc) return dc->GetOptimization();
    return (FALSE);
}

wxPen* wxWindow::GetPen(void)
{
    if (dc) return dc->GetPen();
    return (NULL);
}

Bool wxWindow::GetPixel(float x, float y, wxColour *col)
{
    if (dc) return dc->GetPixel(x, y, col);
    return (FALSE);
}

void wxWindow::GetSize(float *w, float *h)
{
    if (dc) dc->GetSize(w, h);
}

int wxWindow::GetTextAlignment(void)
{
    if (dc) return dc->GetTextAlignment();
    return wxALIGN_TOP_LEFT;
}

wxColour& wxWindow::GetTextBackground(void)
{
    if (dc) return dc->GetTextBackground();
    return (bg);
}

void wxWindow::GetTextExtent(const char *s, float *w, float *h, float *descent,
			     float *ext_leading, wxFont *theFont,
			     Bool use16bit)
{
    if (dc) {
	dc->GetTextExtent(s, w, h, descent, ext_leading, theFont, use16bit);
	return;
    }

    int direction, ascent, descent2; XCharStruct overall;

    if (!theFont) theFont = &font;
    XTextExtents(theFont->GetInternalFont(), s, strlen(s), &direction, &ascent, &descent2, &overall);
    *w = float(overall.width);
    *h = float(ascent + descent2);
    if (descent) *descent = (float)descent2;
    if (ext_leading) *ext_leading = 0.0;
}

wxColour& wxWindow::GetTextForeground(void)
{
    if (dc) return dc->GetTextForeground();
    return (fg);
}

void wxWindow::IntDrawLine(int x1, int y1, int x2, int y2)
{
    if (dc) dc->IntDrawLine(x1, y1, x2, y2);
}

void wxWindow::IntDrawLines(int n, wxIntPoint pts[], int xoff, int yoff)
{
    if (dc) dc->IntDrawLines(n, pts, xoff, yoff);
}

int wxWindow::LogicalToDeviceX(float x)
{
    if (dc) return dc->LogicalToDeviceX(x);
    return int(x);
}

int wxWindow::LogicalToDeviceXRel(float x)
{
    if (dc) return dc->LogicalToDeviceXRel(x);
    return int(x);
}

int wxWindow::LogicalToDeviceY(float y)
{
    if (dc) return dc->LogicalToDeviceY(y);
    return int(y);
}

int wxWindow::LogicalToDeviceYRel(float y)
{
    if (dc) return dc->LogicalToDeviceYRel(y);
    return int(y);
}

float wxWindow::MaxX(void)
{
    if (dc) return dc->MaxX();
    return (0.0);
}

float wxWindow::MaxY(void)
{
    if (dc) return dc->MaxY();
    return (0.0);
}

float wxWindow::MinX(void)
{
    if (dc) return dc->MinX();
    return (0.0);
}

float wxWindow::MinY(void)
{
    if (dc) return dc->MinY();
    return (0.0);
}

Bool wxWindow::Ok(void)
{
    if (dc) return dc->Ok();
    return (FALSE);
}

void wxWindow::ScaleGDIClasses(Bool gdi_scaling)
{
    if (dc) dc->ScaleGDIClasses(gdi_scaling);
}

void wxWindow::SetAxisOrientation(Bool x_left_right, Bool y_bottom_up)
{
    if (dc) dc->SetAxisOrientation(x_left_right, y_bottom_up);
}

void wxWindow::SetBackground(wxBrush *brush)
{
    if (dc)
	dc->SetBackground(brush);
    SetBackgroundColour(brush->GetColour());
}

void wxWindow::SetBackgroundMode(int mode)
{
    if (dc) dc->SetBackgroundMode(mode);
}

void wxWindow::SetBrush(wxBrush *brush)
{
    if (dc) dc->SetBrush(brush);
}

void wxWindow::SetClippingRegion(float x, float y, float w, float h)
{
    if (dc) dc->SetClippingRegion(x, y, w, h);
}

void wxWindow::SetColourMap(wxColourMap *new_cmap)
{
    // wxWindow data
    cmap = new_cmap ? *new_cmap : *wxAPP_COLOURMAP;
    // set X Colormap and WM_COLORMAP_WINDOWS property, if window does exist
    // otherwise it will be done by AfterRealize
    if (!first_painting)
	SetColourMapWMHint();
}

void wxWindow::SetColourMapWMHint(void)
{
    // apply colormap to all widgets
    if (X->frame && XtWindow(X->frame))
	XSetWindowColormap(XtDisplay(X->frame), XtWindow(X->frame), cmap.GetColormap());
    if (X->priv_frame && XtWindow(X->priv_frame))
	XSetWindowColormap(XtDisplay(X->priv_frame), XtWindow(X->priv_frame), cmap.GetColormap());
    if (X->handle && XtWindow(X->handle))
	if (dc) dc->SetColourMap(&cmap);
	else    XSetWindowColormap(XtDisplay(X->handle), XtWindow(X->handle), cmap.GetColormap());
    // set WM_COLORMAP_WINDOWS property
    if (X->handle && XtWindow(X->handle) && cmap.IsPrivate()) {
	// search for the frame of this widget
	wxWindow *win = wxFindFrame(this);
	// if found: set focus
	if (win) {
	    /*
	     * The top level window _must_ appear in the list,
	     * otherwise it gets the highest priority implicitly.
	     */
	    Window win_list[2];
	    win_list[0] = XtWindow(X->handle);
	    win_list[1] = XtWindow(win->FWidget());
	    if (XSetWMColormapWindows(XtDisplay(X->frame), win_list[1], win_list, 2) == 0)
		wxError("can't install private colormap", "wxWindow");
	}
    }
}

void wxWindow::SetDeviceOrigin(float x, float y)
{
    if (dc) dc->SetDeviceOrigin(x, y);
}

void wxWindow::SetFont(wxFont *new_font)
{
    // set DC data
    if (dc) dc->SetFont(new_font);
    // wxWindow data
    if (!new_font) return;
    // apply to widget
    if (X->handle)
	XtVaSetValues(X->handle, XtNfont, new_font->GetInternalFont(), NULL);
    // after the widget has adjusted itself, the old font can be freed...
    font = *new_font;
}

void wxWindow::SetLogicalFunction(int fkt)
{
    if (dc) dc->SetLogicalFunction(fkt);
}

void wxWindow::SetLogicalOrigin(float x, float y)
{
    if (dc) dc->SetLogicalOrigin(x, y);
}

void wxWindow::SetLogicalScale(float xs, float ys)
{
    if (dc) dc->SetLogicalScale(xs, ys);
}

void wxWindow::SetMapMode(int mode)
{
    if (dc) dc->SetMapMode(mode);
}

void wxWindow::SetOptimization(Bool opt)
{
    if (dc) dc->SetOptimization(opt);
}

void wxWindow::SetPen(wxPen *pen)
{
    if (dc) dc->SetPen(pen);
}

void wxWindow::SetTextAlignment(int new_alignment)
{
    if (dc) dc->SetTextAlignment(new_alignment);
}

void wxWindow::SetTextBackground(wxColour *col)
{
    if (dc) dc->SetTextBackground(col);
}

void wxWindow::SetTextForeground(wxColour *col)
{
    if (dc) dc->SetTextForeground(col);
}

void wxWindow::SetUserScale(float xs, float ys)
{
    if (dc) dc->SetUserScale(xs, ys);
}
