/*								-*- C++ -*-
 * $Id: WIN_checkbox.h,v 1.1 1996-09-25 11:06:47+02 mho Exp $
 *
 * Purpose: check box panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef CheckBox_h
#define CheckBox_h

#ifdef __GNUG__
#pragma interface
#endif

class wxBitmap;
class wxPanel;

class wxCheckBox: public wxItem {
DECLARE_DYNAMIC_CLASS(wxCheckBox)
public:
    wxCheckBox(void);
    wxCheckBox(wxPanel *panel, wxFunction func, Const char *label,
	       int x=-1, int y=-1, int width=-1, int height=-1,
	       long style=0, Constdata char *name=wxCheckBoxNameStr);
    wxCheckBox(wxPanel *panel, wxFunction func, wxBitmap *bitmap,
	       int x=-1, int y=-1, int width=-1, int height=-1,
	       long style=0, Constdata char *name=wxCheckBoxNameStr);
    wxCheckBox(wxPanel *panel, wxFunction func, wxBitmap& bitmap,
	       int x=-1, int y=-1, int width=-1, int height=-1,
	       long style=0, Constdata char *name=wxCheckBoxNameStr);
    
    Bool Create(wxPanel *panel, wxFunction func, Const char *label,
		int x=-1, int y=-1, int width=-1, int height=-1,
		long style=0, Constdata char *name=wxCheckBoxNameStr);
    Bool Create(wxPanel *panel, wxFunction func, wxBitmap *bitmap,
		int x=-1, int y=-1, int width=-1, int height=-1,
		long style=0, Constdata char *name=wxCheckBoxNameStr);
    Bool Create(wxPanel *panel, wxFunction func, wxBitmap& bitmap,
		int x=-1, int y=-1, int width=-1, int height=-1,
		long style=0, Constdata char *name=wxCheckBoxNameStr);

    void AllowResize(Bool allow);
    void SetAlignment(long alignment);
    Bool GetValue(void);
    void SetValue(Bool state);
    void SetLabel(char *label);
    void SetLabel(wxBitmap *bitmap);
    void SetLabel(wxBitmap& bitmap);
private:
    wxBitmap bmp;
    #ifdef Have_Xt_Types
    static void OnEventCallback(Widget, XtPointer, XtPointer);
    static void OffEventCallback(Widget, XtPointer, XtPointer);
    #endif
};

#endif // CheckBx_h
