/* BeroList WWW gateway        */
/* Display/Edit single message */
/* $Id: display.c,v 1.1.1.1 1998/08/21 18:11:02 root Exp $ */

#include "list.h"
#include "tool.h"
#include "cgitool.h"
#include "cgipath.h"
#include <gdbm.h>
#ifdef HAVE_GETHOSTBYNAME
	#include <netdb.h>
#endif
#ifndef HOST
	char *hostname;
	#define HOST hostname
	#define GET_HOST
#endif

void errhead()
{
	html_head("Server configuration error");
	puts("<H1>Server configuration error</H1><HR>");
}

int main(int argc, char *argv[])
{
	char *listname, *configfile, *config, *archivefile;
	char *d_key, *s;
	char *subject,*from,*msgdat,*message;
	GDBM_FILE db;
	datum key,content;
	unsigned int num,i,function=0;
	register int j;

	#ifdef GET_HOST
		#ifdef HAVE_GETHOSTBYNAME
			struct hostent *x;
			hostname=salloc(1024);
			gethostname(hostname,1024);
			x=gethostbyname(hostname);
			if (x) strcpy(hostname,x->h_name); else strcpy(hostname,"localhost");
		#else   /* Try to determine hostname anyway */
			hostname=salloc(1024);
			gethostname(hostname,1024);
			hostname[slen(hostname)+1]='\0';
			hostname[slen(hostname)]='.';
			getdomainname(hostname+slen(hostname),1024-slen(hostname)-1);
		#endif
	#endif
	
	listname=cgi_scan("list");
	if(listname==NULL) {
		errhead();
		puts("The BeroList message list script is not configured correctly.<BR>");
		puts("You have to specify the parameter list=listname.");
		exit(1);
	}
	
	if(scasecmp(cgi_scan("function"),"edit")==0)
		function=1;

	s=cgi_scan("msg");
	if(s==NULL)
		i=0;
	else
		i=atoi(s);
	
	configfile=salloc(slen(LISTDIR)+slen(listname)+9);
	sprintf(configfile,"%s/%s.config",LISTDIR,listname);
	config=readfile(configfile);
	if(config==NULL) {
		errhead();
		printf("The specified list, %s, does not exist.",listname);
		exit(1);
	}

	if(function==1) {
		if(extract(config,"www-password=",'\n')==NULL) {
			errhead();
			puts("This list is not configured for WWW based administration.");
		} else if(scmp(extract(config,"www-password=",'\n'),cgi_scan("pw"))!=0) {
			errhead();
			puts("Wrong password.");
		}
	}
	archivefile=extract(config,"archive=",'\n');
	if(archivefile==NULL) {
		archivefile=salloc(slen(LISTDIR)+slen(listname)+10);
		sprintf(archivefile,"%s/%s.archive",LISTDIR,listname);
	}
	if(scasecmp(archivefile,"none")==0) {
		errhead();
		printf("The specified list, %s, does not archive messages.",listname);
		exit(1);
	} else if(archivefile[0]!='/') {
		archivefile=(char *) realloc(archivefile,slen(LISTDIR)+slen(archivefile)+2);
		sprintf(archivefile,"%s/%s\0",LISTDIR,archivefile);
	}
	db=gdbm_open(archivefile,0,GDBM_READER,00664,0);
	if(db==NULL) {
		errhead();
		printf("Couldn't open archive file for list %s...<BR>Archive empty?",listname);
		exit(1);
	}

	if(function==0)
		html_head("BeroList messages");
	else
		html_head("BeroList message editor");
	d_key=salloc(4);
	strcpy(d_key,"num");
	key.dptr=d_key;
	key.dsize=3;
	content=gdbm_fetch(db,key);
	free(d_key);
	num=atoi(content.dptr);
	if(i<0) i=0;
        if(num<=i) i=num-1;
        s=salloc(12);
        sprintf(s,"s%u",i);
        key.dptr=s;
        key.dsize=slen(s);
        content=gdbm_fetch(db,key);
        subject=salloc(content.dsize+1);
        strncpy(subject,content.dptr,content.dsize);

	sprintf(s,"d%u",i);
	key.dptr=s;
	key.dsize=slen(s);
	content=gdbm_fetch(db,key);
	if(content.dptr==NULL) {
		msgdat=salloc(20);
		sprintf(msgdat,"(date/time unknown)");
	} else {
		msgdat=salloc(content.dsize+1);
		strncpy(msgdat,content.dptr,content.dsize);
	}

        sprintf(s,"f%u",i);
        key.dptr=s;
        key.dsize=slen(s);
        content=gdbm_fetch(db,key);
        from=salloc(content.dsize+1);
        strncpy(from,content.dptr,content.dsize);
        free(s);
	if(function==0)
	        printf("<CENTER><H1>%s</H1>From <A HREF=mailto:%s>%s</A><BR>List <A HREF=mailto:%s@%s>%s</A><BR>%s</CENTER><HR>",subject,email(from),realname(from),listname,HOST,listname);
	else {
		printf("<FORM METHOD=GET ACTION=%s>",EDIT_CGI);
		puts("<INPUT TYPE=HIDDEN NAME=function VALUE=edit>");
		printf("<INPUT TYPE=HIDDEN NAME=list VALUE=%s>",listname);
		printf("<INPUT TYPE=HIDDEN NAME=pw VALUE=%s>",cgi_scan("pw"));
		printf("<INPUT TYPE=HIDDEN NAME=msg VALUE=%u>",i);
		printf("Message <INPUT TYPE=TEXT NAME=subject VALUE=\"%s\">",subject);
		printf("<BR>From <INPUT TYPE=TEXT NAME=from VALUE=\"%s\"><HR><BR><TEXTAREA NAME=text>",from);
	}
        free(from);
	s=salloc(12);
	sprintf(s,"%u",i);
	key.dptr=s;
	key.dsize=slen(s);
	content=gdbm_fetch(db,key);
	message=salloc(content.dsize+1);
	strncpy(message,content.dptr,content.dsize);
	if(function==0) {
		for(j=0;j<=slen(message);j++)
		{
			if(message[j]=='\n')
				puts("<BR>");
			else
				putchar(message[j]);
		}
		puts("<HR>");
		if(i>0)		printf("<A HREF=\"%s?list=%s&msg=%u\">previous message</A>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",DISPLAY_CGI,listname,i-1);
		printf("<A HREF=%s?list=%s>message list</A>&nbsp;&nbsp;&nbsp;&nbsp;",MESSAGES_CGI,listname);
		if(i<num-1)	printf("<A HREF=\"%s?list=%s&msg=%u\">next message</A>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",DISPLAY_CGI,listname,i+1);
	} else {
		puts(message);
		puts("</TEXTAREA><INPUT TYPE=SUBMIT VALUE=Apply>");
		puts("<HR>");
		if(i>0)		printf("<A HREF=\"%s?list=%s&function=edit&msg=%u&pw=%s\">previous message</A>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",DISPLAY_CGI,listname,i-1,cgi_scan("pw"));
		printf("<A HREF=%s?list=%s&function=edit&pw=%s>message list</A>&nbsp;&nbsp;&nbsp;&nbsp;",MESSAGES_CGI,listname,cgi_scan("pw"));
		if(i<num-1)	printf("<A HREF=\"%s?list=%s&msg=%u&function=edit&pw=%s\">next message</A>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",DISPLAY_CGI,listname,i+1,cgi_scan("pw"));
	}
	printf("<P><HR><ADDRESS><CENTER><A HREF=http://www.croftj.net/~bero/BeroList/>%s</A> - &copy; by <A HREF=mailto:bero@linux.net.eu.org>Bernhard Rosenkr&auml;nzer</A></ADDRESS>",VERSION);
	return 0;
}
