/* $Id: dynarray.c,v 1.2 1998/10/20 19:57:46 hurtta Exp $
 *
 * Initially written by: Michael Elkins <elkins@aero.org>, 1995/06/01
 */

/** routines for handling of dynamic arrays **/

char **
DynamicArray (p, record_size, max, n)
char **p;
int record_size;
int *max;
int n;
{
	int newmax, j;
	char **c;

	newmax = *max + n;

	if (!p)
		c = (char**)safe_malloc(record_size * (n+1));
	else
		c = (char**)safe_realloc(p, record_size * (newmax+1));

	if (!c)
		return(0);

	/* We reserver in above (newmax+1) elements --
	 * element c[newmax] must be always NULL so DestroyDynamicArray
	 * works.
	 */
	for (j = *max ; j <= newmax ; j++)
		c[j] = 0;

	*max = newmax;

	return(c);
}

void
DestroyDynamicArray (p)
char **p;
{
	char **b;

	if (!p)
		return;
	b = p;
	while (*b)
		free(*b++);
	free(p);
}
