static char rcsid[] = "@(#)$Id: menu2.c,v 1.2.4.1 1999/09/25 18:18:15 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2.4.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 * This code originally written by Michael Elkins <elkins@aero.org>.
 *****************************************************************************/

#include "headers.h"
#include "menu2.h"
#include "me.h"
#include "s_elm.h"

#define BOL 1
#define STR 2
#define INT 3

static int do_item P_((struct menu_item *));
static int do_item (it)
     struct menu_item *it;
{
  short len;
  char buf[STRING];
  int ch;

  ClearLine (it->offset);
  Write_to_screen (FRM("%s"),it->option);
  len = strlen (it->option) + 1;
  if (it->type == STR)
    return 
      optionally_enter (it->d.c, it->offset, len, 
			OE_APPEND_CURRENT|OE_REDRAW_MARK,
			it->size);
  else if (it->type == BOL) {
    for (;;) {
      MoveCursor (it->offset, len);
      CleartoEOLN ();
      if (*(it->d.i) == TRUE)
	Write_to_screen (CATGETS(elm_msg_cat, ElmSet, 
				 ElmMenu2True,
				 "TRUE"));
      else if (*(it->d.i) == FALSE)
	Write_to_screen (CATGETS(elm_msg_cat, ElmSet, 
				 ElmMenu2False,
				 "FALSE"));
      ch = ReadCh (OE_REDRAW_MARK);
      if (ch == EOF) 
	return -1;
      if (ch == REDRAW_MARK)
	return REDRAW_MARK;
      if (ch == '\n')
	return 0;
      else if (ch == ' ')
	*(it->d.i) = *(it->d.i) ? FALSE : TRUE;
    }
  }
  else if (it->type == INT) {
    int code;
    elm_sfprintf (buf,sizeof buf,
		  FRM("%d"), *(it->d.i));
    code = optionally_enter (buf, it->offset, len, 
			     OE_APPEND_CURRENT|OE_REDRAW_MARK,
			     sizeof buf);
    if (code != 0)
      return code;
    *(it->d.i) = atoi (buf);
  }
  return 0;
}

void
generic_menu (items, max, title, prompt)
     struct menu_item items[];
     short max;
     char *prompt, *title;
{
  short i = 0;
  char buf[STRING], buf2[STRING];
  int ch;
  short update = TRUE;
  int precmd = 0;

  ClearScreen ();
  for (;;) {
    if (update) {
      Centerline (1, title);
      for (i = 0 ; i < max ; i++) {
	strfcpy(buf,items[i].option, sizeof buf);
	strfcat(buf," ",sizeof buf);
	if (items[i].type == BOL) {
	  if (*items[i].d.i == TRUE)
	    strfcat (buf, "TRUE", sizeof buf);
	  else
	    strfcat (buf, "FALSE", sizeof buf);
	}
	else if (items[i].type == STR)
	  strfcat (buf, items[i].d.c, sizeof buf);
	else if (items[i].type == INT) {
	  elm_sfprintf (buf2, sizeof buf2,
			FRM("%d"), 
			*items[i].d.i);
	  strfcat (buf, buf2, sizeof buf);
	}
	ClearLine(items[i].offset);
	PutLine0 (items[i].offset, 0, buf);
      }
      update = FALSE;
    }
    ClearLine (elm_LINES-2);
    PutLine0 (elm_LINES-2, 0, prompt);
    if (precmd) {
      ch = precmd;
      precmd = 0;
    } else
      ch = ReadCh (REDRAW_MARK);
    if (EOF == ch)
      return;
    switch (ch) {
    case '\n':
      return;
    case REDRAW_MARK:
      update = TRUE;
      break;
    default:
      for (i = 0; i < max ; i++) {
	if (ch == items[i].key) {
	  int code = do_item (&items[i]);
	  if (REDRAW_MARK == code)
	    precmd = ch;
	  if (-1 == code)
	    return;
	  update = TRUE;
	  break;
	}
      }
      if (i == max && isascii(ch)) {
	for (i = 0; i < max ; i++) {
	  if (isascii (items[i].key) && isascii(ch) && 
	      tolower(ch) == tolower(items[i].key)) {
	    int code = do_item (&items[i]);
	    if (REDRAW_MARK == code)
	      precmd = ch;
	    if (-1 == code)
	      return;
	    update = TRUE;
	    break;
	  }
	}
      }
    }
  }
  /* Not reached. */
}



