
static char rcsid[] = "@(#)$Id: mkhdrs.c,v 1.6.2.1 1999/08/27 04:06:12 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6.2.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This contains all the header generating routines for the ELM
    program.

**/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

char *elm_date_str();

static void expand_backquote P_((char *buffer,
				 FILE *filedesc));

void generate_reply_to(current_header,headers)
     struct header_rec * current_header;
     struct mailing_headers *headers;
{
    /** Generate an 'in-reply-to' message... **/
    char buffer[SLEN], date_buf[SLEN], buffer2[LONG_STRING];

    if (headers->in_reply_to)
	free(headers->in_reply_to);
    headers->in_reply_to = NULL;
    
    if (current_header) {	
	int q = 0;
	char  *d = buffer2;
	struct addr_item *p;
	
	for (p = current_header->from;
	     p && p->addr && p->fullname &&
		 d - buffer2 < sizeof buffer2 - 7;
	     p++) {	    
	    CONST char *str = "", *c;

	    if (p->fullname[0]) 
		str = p->fullname;
	    else
		str = p->addr;
	    
	    if (d > buffer2) {
		d--;  /* overwrite last " */
		*d++ = ',';
		*d++ = ' ';
	    } else
		*d++ = '"';
	    
	    /* Remove unquoted " -characters from buffer.
	     */
	    for (c = str ;
		 '\0' != *c && d - buffer2 < sizeof buffer-3; 
		 c++) {
		if (q) {
		    *d++ = '\\';
		    *d++ = *c;
		    q = 0;
		} else if ('\\' == *c) {
		    q = 1;
		} else if ('"' != *c) {
		    *d++ = *c;
		}
	    }
	    *d++ = '"';
	    *d = '\0';
	}
	if (d == buffer2 && current_header->env_from[0])
	    elm_sfprintf(buffer2,
			 sizeof buffer2,
			 FRM("(env: %s)"),
			 current_header->env_from);
	else if (d == buffer2)
	    strfcpy(buffer2,
		    "someone",
		    sizeof buffer2);
	
	headers->in_reply_to = 
	    elm_message(FRM("%s%s %s at \"%s\""),
			current_header->messageid,
			current_header->messageid[0] ? " from" : "From",
			buffer2,
			elm_date_str(date_buf, 
				     current_header->time_sent + 
				     current_header->tz_offset,
				     sizeof date_buf));
    }
}

void add_mailheaders(filedesc)
     FILE *filedesc;
{
	/** Add the users .mailheaders file if available.  Allow backquoting 
	    in the file, too, for fortunes, etc...*shudder*
	**/

	FILE *fd;
	char buffer[SLEN];


	if ((fd = fopen(user_mailheaders, "r")) != NULL) {
	  while (fgets(buffer, SLEN, fd) != NULL)
	    if (strlen(buffer) < 2) {
	      dprint(2, (debugfile,
	         "Strlen of line from .elmheaders is < 2 (write_header_info)"));
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmWarningBlankIgnored,
				"Warning: blank line in %s ignored!"), 
			user_mailheaders);
	      if (sleepmsg > 0)
		    sleep(sleepmsg);
	    }
	    else if (occurances_of(BACKQUOTE, buffer) >= 2) 
	      expand_backquote(buffer, filedesc);
	    else 
	      fprintf(filedesc, "%s", buffer);

	    fclose(fd);
	}
}

static void expand_backquote(buffer, filedesc)
     char *buffer;
     FILE *filedesc;
{
	/** This routine is called with a line of the form:
		Fieldname: `command`
	    and is expanded accordingly..
	**/

	FILE *fd;
	char command[SLEN], command_buffer[SLEN], fname[SLEN],
	     prefix[SLEN];
	register int i, j = 0;

	for (i=0; buffer[i] != BACKQUOTE; i++)
	  prefix[j++] = buffer[i];
	prefix[j] = '\0';

	j = 0;

	for (i=chloc(buffer, BACKQUOTE)+1; buffer[i] != BACKQUOTE;i++)
	  command[j++] = buffer[i];
	command[j] = '\0';

	elm_sfprintf(fname,sizeof fname,
		     FRM("%s%s%d"), temp_dir, temp_print, getpid());

	elm_sfprintf(command_buffer, sizeof command_buffer,
		     FRM("%s > %s"), command, fname);

	(void) system_call(command_buffer, 0);

	if ((fd = fopen(fname, "r")) == NULL) {
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBackquoteCmdFailed,
			    "Backquoted command \"%s\" in elmheaders failed."),
		    command);
	  return;	
	}

	/* If we get a line that is less than 80 - length of prefix then we
	   can toss it on the same line, otherwise, simply prepend each line
	   *starting with this line* with a leading tab and cruise along */

	if (fgets(command_buffer, SLEN, fd) == NULL) 
	  fprintf(filedesc, prefix);
	else {
	  if (strlen(command_buffer) + strlen(prefix) < 80) 
	    fprintf(filedesc, "%s%s", prefix, command_buffer);
	  else
	    fprintf(filedesc, "%s\n\t%s", prefix, command_buffer);
	  
	  while (fgets(command_buffer, SLEN, fd) != NULL) 
	    fprintf(filedesc, "\t%s", command_buffer);
	
	  fclose(fd);
	}

	unlink(fname);	/* don't leave the temp file laying around! */
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
