static char rcsid[] = "@(#)$Id: newmbox.c,v 1.29.2.2 1999/09/25 18:18:16 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.29.2.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/**  read new folder **/

#include "headers.h"
#include "s_elm.h"

#include <sys/stat.h>
#include <errno.h>

#include "me.h"   /* for defination of null_decode and text_decode */
extern int errno;

char *error_description();
long bytes();
#if  !defined(ANSI_C) && !defined(atol) /* avoid problems with systems that declare atol as a macro */
extern void rewind();
extern long atol();
#endif

static int read_headers P_((int));   /* Prototype */
static void mk_temp_mail_fn P_((char *, char *, int)); /* Prototype */


static void open_temphandle P_((
			    struct folder_info *folder,
			    int temp_handle));

static void open_temphandle(new_folder,temp_handle)
     struct folder_info *new_folder;
     int temp_handle;
{
  dprint(10, (debugfile,
	     "open_temphandle: new_folder=%X (%s)\n",
	      new_folder,new_folder->cur_folder));

  if ((new_folder -> fh_temp = fdopen(temp_handle,"w+")) == NULL) {
    int err = errno;
    close(temp_handle);   /* - K E H */
    MoveCursor(elm_LINES, 0);
    Raw(OFF);
    printf(catgets(elm_msg_cat, ElmSet, ElmCouldntOpenForTemp,
		   "\nCouldn't open file %s for use as temp file.\n"),
	   new_folder-> cur_tempfolder);
    printf("** %s. **\n", error_description(err));
    dprint(1, (debugfile,
	       "Error: Couldn't open file %s as temp mbox.  errno %s (%s)\n",
	       new_folder-> cur_tempfolder, error_description(err), "---"));
    rm_temps_exit();
  }
}

static void truncate_tempfolder P_((struct folder_info *folder));
static void truncate_tempfolder(folder)
     struct folder_info *folder;
{
  int need_reopen = 1;

  dprint(10, (debugfile,
	     "truncate_tempfolder: folder=%X (%s)\n",
	      folder,folder->cur_folder));

#ifdef FTRUNCATE  
  if (folder->fh_temp) {
    rewind(folder->fh_temp);
    if (0 == ftruncate(fileno(folder->fh_temp),0)) {
      need_reopen = 0;
      dprint(10, (debugfile,
		  "truncate_tempfolder: tempfile %s truncated (not recreated)\n",
		  folder->cur_tempfolder));
    }
    else
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSorryCantTruncateTemp,
			"Sorry, can't truncate the temp file %s [%s]!"),
		folder -> cur_tempfolder, error_description(errno));    
  }
#endif
  if (need_reopen) {
    int temp_handle;
    if (0 != unlink(folder -> cur_tempfolder) && errno != ENOENT ||
	(temp_handle = open(folder-> cur_tempfolder, 
			    O_RDWR|O_CREAT|O_EXCL,
			    0600)) == -1) {
      int err = errno;
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSorryCantTruncateTemp,
			"Sorry, can't truncate the temp file %s [%s]!"),
		folder -> cur_tempfolder, error_description(err));    
    } else {
      dprint(10, (debugfile,
		  "truncate_tempfolder: tempfile %s opened (possibly created)\n",
		  folder->cur_tempfolder));

      if (folder->fh_temp)
	fclose (folder->fh_temp);
      open_temphandle(folder,temp_handle);
      elm_chown(folder->cur_tempfolder, userid, groupid);
      chmod(folder -> cur_tempfolder, 0700);       
    }
  }
}

void close_folder(folder) 
     struct folder_info *folder;
{
  dprint(10, (debugfile,
	     "close_folder: folder=%X (%s)\n",
	      folder,folder->cur_folder));

  if (folder -> fh_folder  == NULL &&
      folder -> fh_temp    == NULL &&
      folder -> lock_state == OFF) {
    dprint(10, (debugfile,
		"close_folder: Already done.\n\n"));
    return;
  }

  if(folder -> folder_type == SPOOL) {
    
    if (folder -> lock_state == ON)
      unlock(0,folder);

    if (unlink(folder -> cur_tempfolder) != 0) {
      if (errno != EEXIST) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSorryCantUnlinkTemp,
			  "Sorry, can't unlink the temp file %s [%s]!\n\r"),
		  folder -> cur_tempfolder, error_description(errno));
      }
    } else {
      dprint(1, (debugfile, 
		 "close_folder: Unlinking tempfile (%s).\n",
		 folder -> cur_tempfolder));
    }
  } else { /* normal folder */
    if (lockfolders)
      Release_the_file(fileno(folder -> fh_folder));      
  }

  if (folder -> fh_folder != NULL)
    fclose(folder -> fh_folder); 
  folder -> fh_folder = NULL;

  if (folder -> fh_temp != NULL)
    fclose(folder -> fh_temp); 
  folder -> fh_temp = NULL;
}

static void leave_old_folder P_((struct folder_info *folder));
static void leave_old_folder(folder) 
     struct folder_info *folder;
{
  dprint(10, (debugfile,
	      "leave_old_folder: folder=%X (%s)\n",
	      folder,folder->cur_folder));
  
  close_folder(folder);

#ifdef	USE_DOTLOCK_LOCKING		
  /* formulate lock file name */
  if (folder->lockfile)
    free(folder->lockfile);
#endif

  if (folder == current_folder)
    current_folder = NULL;

  if (folder -> cur_folder)
    free(folder -> cur_folder);
  free(folder);
}

static struct folder_info *enter_new_folder P_((char *new_file));

struct folder_info *enter_new_folder(new_file) 
     char *new_file;
{
  struct folder_info *new_folder = NULL;

  dprint(10, (debugfile,
	      "enter_new_folder(%s)\n",
	      new_file));

  new_folder = safe_malloc(sizeof (struct folder_info));
  new_folder -> lock_state = OFF;
  new_folder -> create_fd  = -1;
  new_folder -> cur_folder = safe_strdup(new_file);
  new_folder -> cur_tempfolder[0] = '\0';
  new_folder -> use_temp = 0;
  new_folder -> fh_folder = NULL;
  new_folder -> fh_temp = NULL;
  new_folder -> mailfile_size = 0;
  new_folder -> lock_state = OFF;
#ifdef	USE_DOTLOCK_LOCKING		/* { USE_DOTLOCK_LOCKING  */
  /* formulate lock file name */
  new_folder->lockfile=safe_strdup(mk_lockname(new_folder->cur_folder));
#endif
  new_folder -> create_fd = -1;

  /* determine type of new mailfile and calculate temp file name */
  if((new_folder -> folder_type = get_folder_type(new_file)) == SPOOL) {
    
    mk_temp_mail_fn(new_folder-> cur_tempfolder, 
		    new_file, sizeof new_folder -> cur_tempfolder);
  
  } else {
    new_folder -> cur_tempfolder[0] = '\0';
    new_folder -> fh_temp = NULL;
  }

  dprint(10, (debugfile,
	      "enter_new_folder=%X (%s)\n",
	      new_folder,new_folder->cur_folder));

  return new_folder;
}

static void session_lock_folder P_((struct folder_info *folder));

static void session_lock_folder(folder)
     struct folder_info *folder;
{

  dprint(10, (debugfile,
	      "session_lock_folder: folder=%X (%s)\n",
	      folder,folder->cur_folder));

  if (folder -> folder_type == SPOOL) {
    int temp_handle;

    /* If we are changing files and we are changing to a spool file,
     * make sure there isn't a temp file for it, because if
     * there is, someone else is using ELM to read the new file,
     * and we don't want to be reading it at the same time.
     */
    
    if ( (temp_handle = open(folder-> cur_tempfolder, 
			     O_RDWR|O_CREAT|O_EXCL,
			     0600)) == -1) {
      int err = errno;

      Raw(OFF);
      if (err == EEXIST) {
	ClearScreen();
	Centerline(15, catgets(elm_msg_cat, ElmSet, ElmAlreadyRunning1,
			       "You seem to have ELM already reading this mail!"));
	Centerline(17, catgets(elm_msg_cat, ElmSet, ElmAlreadyRunning2,
			       "You may not have two copies of ELM running simultaneously.  -- Exiting --"));
	Centerline(18, catgets(elm_msg_cat, ElmSet, ElmAlreadyRunning3,
			       "If this is in error, then you'll need to remove the following file:"));
	Centerline(19, folder -> cur_tempfolder);
	MoveCursor(elm_LINES, 0);  /* so shell prompt upon exit is on newline */
	sleep_message();
	silently_exit();
      } 
      MoveCursor(elm_LINES, 0);
      
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedCreateTmpFolder,
			"Failed to create %.50s: %.60s"),
		folder -> cur_tempfolder,
		error_description(err));
      sleep_message();
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmIGiveUp,
			"Ahhhh... I give up."));
      sleep_message();
      silently_exit();	/* leave without tampering with it! */
    } 
    dprint(1, (debugfile, 
	       "Creating tempfile (%s).\n",
	       folder -> cur_tempfolder));
    
    open_temphandle(folder,temp_handle);
    elm_chown(folder->cur_tempfolder, userid, groupid);
    chmod(folder -> cur_tempfolder, 0700);	/* shut off file for other people! */

  } else {  /* normal folder */
    if (lockfolders) {
      switch (Grab_the_file(fileno(folder -> fh_folder))) {
      case FLOCKING_OK:
	dprint(1, (debugfile, 
		   "Folder locked (%s).\n",
		   folder -> cur_folder));
	break;
      case FLOCKING_RETRY:
	Raw(OFF);
	ClearScreen();
	Centerline(19, catgets(elm_msg_cat, ElmSet, ElmAlreadyRunning1,
			       "You seem to have ELM already reading this mail!"));	
	MoveCursor(elm_LINES, 0);  /* so shell prompt upon exit is on newline */
	sleep_message();
	silently_exit();
	break;
      case	FLOCKING_FAIL:
	MoveCursor(elm_LINES, 0);
	Raw(OFF);
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveErrorLockFolder,
			  "Error encountered while attempting to lock folder %s"), 
		  folder->cur_folder);
	lib_error(FRM("** %s. **"), 
		  error_description(errno));
	sleep_message();
	silently_exit();
	break;
      }
    }
  }
}

int reopen_folder_lock_sessionlock(folder)
     struct folder_info *folder;
{
  dprint(10, (debugfile,
	      "reopen_folder_lock_sessionlock: folder=%X (%s)\n",
	      folder,folder->cur_folder));
  if (folder -> folder_type == SPOOL) {
    if (!folder -> fh_temp) {
      dprint(10, (debugfile,
		  "reopen_folder_lock_sessionlock: SPOOL - tempfolder not open\n"));
      session_lock_folder(folder);
    } else {
      int temp_handle;
      if ( (temp_handle = open(folder-> cur_tempfolder, 
			       O_RDWR,
			       0600)) == -1) {
	int err = errno;

	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSorryCantReopenTemp,
			  "Sorry, can't reopen the temp file %s [%s]!"),
		  folder -> cur_tempfolder, error_description(err));    
	return 0;
      }
      dprint(10, (debugfile,
		  "reopen_folder_lock_sessionlock: tempfile %s re-opened\n",
		  folder->cur_tempfolder));

      fclose(folder -> fh_temp);
      open_temphandle(folder,temp_handle);
    }
  }
   
  if (folder->fh_folder)
    fclose(folder->fh_folder);
  folder->fh_folder = NULL;
  
  if (!open_folder_lock(OUTGOING,folder))
    return 0;

  if (folder -> folder_type != SPOOL)
    session_lock_folder(folder);

  dprint(10, (debugfile,
	      "reopen_folder_lock_sessionlock=1 (DONE)\n"));
  return 1;
}   

int open_folder_lock(direction,folder) 
     int direction;
     struct folder_info *folder;
{
  dprint(10, (debugfile,
	      "open_folder_lock: folder=%X (%s)\n",
	      folder,folder->cur_folder));

  if ((errno = can_open(current_folder->cur_folder, 
			"r+")) != 0) {
    dprint(1, (debugfile,
	       "Error: given file %s as folder - unreadable (%s)!\n", 
	       current_folder->cur_folder, 
	       error_description(errno)));
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantOpenFolderRead,
		      "Can't open folder '%s' for reading!\n"), 
	      current_folder->cur_folder);
    sleep_message();
    return 0;
  }
  
  if (!current_folder->fh_folder) {
    if ((current_folder->fh_folder = fopen(current_folder->cur_folder,"r+"))
	== NULL)  {
      int err = errno;
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantOpenFolderRead,
			"Can't open folder '%s' for reading!\n"), 
		current_folder->cur_folder);
      sleep_message();
      return 0;
    }
  } else
    rewind(current_folder->fh_folder);
  
  if (current_folder->folder_type == SPOOL) 
    lock(direction, current_folder);
    
  return 1;
}

int newmbox(new_file, adds_only)
     char *new_file;
     int adds_only;
{
  /** Read a folder.

    new_file	- name of folder  to read. It is up to the calling
                  function to make sure that the file can be
                  read by the user. This is not checked in this
		  function. The reason why it is not checked here
		  is due to the situation where the user wants to
		  change folders: the new folder must be checked
		  for access *before* leaving the old one, which
		  is before this function gets called.
    adds_only	- set if we only want to read newly added messages to
                  same old folder.

		  **/

  int  same_file;
  int err;
  struct folder_info *new_folder = NULL;

  /* determine whether we are changing files */
  same_file = current_folder && 
    0 == (strcmp(new_file, current_folder -> cur_folder));

  if (same_file)
    new_folder = current_folder;
  else {
    new_folder = enter_new_folder(new_file);
  }

  /* If we were reading a spool file and we are not just reading
   * in the additional new messages to the same file, we need to
   * truncate the corresponding tempfile.
   */

  if (!same_file) {
    if (current_folder)
      leave_old_folder(current_folder);
    current_folder = new_folder;
  }

  clear_error();
  clear_central_message();

  if (!current_folder->fh_folder) {
    if ((current_folder->fh_folder = fopen(current_folder->cur_folder,"r+"))
	== NULL)  {
      if (errno != ENOENT /* error on anything but file not exist */
	  || current_folder->folder_type != SPOOL) { 
	err = errno;
	MoveCursor(elm_LINES,0);
	Raw(OFF);
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailOnOpenNewmbox,
			  "\nfail on open in newmbox, open %s failed!!\n"),
		  current_folder->cur_folder);
	lib_error(FRM("** %s. **\n"), 
		  error_description(err));
	dprint(1, (debugfile, "fail on open in newbox, file %s!!\n",
		   current_folder->cur_folder));
	rm_temps_exit();
      }
      else { /* nonexisting spool file */
	/* mailboxes does not need to be opened to
	 * be session locked
	 */
	if (!same_file)
	  session_lock_folder(current_folder);
	else
	  truncate_tempfolder(current_folder);

	current_folder->mailfile_size = 0;    /* must non-existant folder */
	message_count = 0;
	selected = 0;	
	return 0;   
      }
    }
    dprint(10, (debugfile, "Mailfile opened: %s\n",
		current_folder->cur_folder));
  } else {
    rewind(current_folder->fh_folder);
  }

  /* folder (as opposite to mailbox) can be session locked
   * only when it is opened. That call can do session locking
   * for both (folders and mailboxes)
   */
  if (!same_file)    
    session_lock_folder(current_folder);
  else if (current_folder->folder_type == SPOOL && !adds_only)
    truncate_tempfolder(current_folder);

reread:
  read_headers(adds_only);

  if (ferror(current_folder->fh_folder)) {
    dprint(1, (debugfile, "error when reading mailfile: %s\n",
	       current_folder->cur_folder));
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorWhenReading,
		      "Error when reading: %s"),
	      current_folder->cur_folder);
    sleep_message();
    if (*def_ans_yes == want_to ("Error when reading! Reread folder?",
				 *def_ans_yes,elm_LINES,0)) {
      adds_only = FALSE;
	
      dprint(1, (debugfile, "rereading mailfile: %s\n",
		 current_folder->cur_folder));
      rewind(current_folder->fh_folder);
      goto reread;
    }
      
    rm_temps_exit();
  }

  if(!same_file)		/* limit mode off if this is a new file */
    selected = 0;
  if (!adds_only)		/* limit mode off if recreating headers */
    selected = 0;		/* because we loose the 'Visible' flag */
  
  dprint(1, (debugfile,
	     "New folder %s type %s temp file %s (%s)\n", 
	     current_folder->cur_folder, 
	     (current_folder -> folder_type == SPOOL ? "spool" : "non-spool"),
	     (*current_folder-> cur_tempfolder ? 
	      current_folder -> cur_tempfolder : "none"), "newmbox"));
  
  return(0);
}

static int is_in_spool P_((char *)); /* prototype */

int get_folder_type(filename)
     char *filename;
{
	/** returns the type of mailfile filename is
	    NO_NAME = no name
	    SPOOL = consisting only of mailhome plus base file name
		    (no intervening directory name)
	    NON_SPOOL = a name that is not SPOOL type above
	 **/

	char *last_slash;
	struct stat    buf;		/* stat command  */

	/* if filename is null or is of zero length */
	if((filename == NULL) || (*filename == '\0')) {
	  dprint(8, (debugfile, 
		     "get_folder_type=NO_NAME: no filename\n"));
	  return(NO_NAME);
	}

	dprint(8, (debugfile, 
		   "get_folder_type: filename=%s\n",filename));

	/* if filename begins with mailhome,
	 * and there is a slash in filename,
	 * and there is a filename after it (i.e. last slash is not last char),
	 * and the last character of mailhome is last slash in filename,
	 * it's a spool file .
	 */
	if(is_in_spool(filename)) {
	  dprint(8, (debugfile, 
		     "get_folder_type=SPOOL\n"));
	  return(SPOOL);
	}
	/* if file name == default mailbox, its a spool file also
	 * even if its not in the spool directory. (SVR4)
	 */
	if (strcmp(filename, defaultfile) == 0) {
	  dprint(8, (debugfile, 
		     "get_folder_type=SPOOL\n"));
	  return(SPOOL);
	  }
        if (stat(filename, &buf) != 0) {
	  int err = errno;
	  dprint(8, (debugfile, 
		     "get_folder_type: errno %s attempting to stat file %s\n", 
		     error_description(err), filename));
	} else {
	  if (buf.st_mode & 07000) { 
	    /* is 'SPOOL' file is special modes set */
	    dprint(8, (debugfile, 
		       "get_folder_type=SPOOL; mode=%05o\n",buf.st_mode));
	    return(SPOOL);
	  }
	}

	dprint(8, (debugfile, 
		   "get_folder_type=NON_SPOOL\n"));
	return(NON_SPOOL);
}

int same_file(name1,name2)
     char *name1, *name2;
{
  struct stat buf1, buf2;
  
  if (0 == strcmp(name1,name2)) {
    dprint(8, (debugfile, 
	       "same_file(%s,%s)=TRUE\n",name1,name2)); 
    return TRUE;
  }

  if (stat(name1, &buf1) != 0) {
    int err = errno;
    dprint(8, (debugfile, 
	       "same_file(%s,%s)=FALSE: %s (errno=%d) attempting to stat file %s\n", 
	       name1,name2,error_description(err), err, name1));
    return FALSE;
  }

  if (stat(name2, &buf2) != 0) {
    int err = errno;
    dprint(8, (debugfile, 
	       "same_file(%s,%s)=FALSE: %s (errno=%d) attempting to stat file %s\n", 
	       name1,name2,error_description(err), err, name2));
    return FALSE;
  }

  if (buf1.st_ino == buf2.st_ino && buf1.st_dev == buf2.st_dev) {
    dprint(8, (debugfile, 
	       "same_file(%s,%s)=TRUE\n",name1,name2)); 
    return TRUE;
  }
  dprint(8, (debugfile, 
	     "same_file(%s,%s)=FALSE\n",name1,name2)); 
  return FALSE;
}

static int is_in_spool(mbox)
     char *mbox;
{
  char * ptr = strrchr(mbox,'/');
  int in_spool = 0;

  if (ptr) {
    char temp = *(++ptr);
    *ptr = '\0';
    in_spool = 0 == strcmp(mbox,mailhome);

    dprint(8,(debugfile,"is_in_spool: base=%s\n",
	      mbox));

    *ptr = temp;
  } else
    ptr = mbox;

  dprint(8,(debugfile,"is_in_spool(%s): in_spool=%d\n",
	    mbox,in_spool));

  if (!in_spool) {
    char tempname[SLEN];
    if (strlen(mailhome) + strlen(ptr) > SLEN-1) {
      dprint(1,(debugfile,
		"is_in_spool(%s): Too long path or mailbox!\n",mbox));
    } else {
      elm_sfprintf(tempname,sizeof tempname,
		   FRM("%s%s"),mailhome,ptr);
      
      if (same_file(tempname,mbox))
	in_spool = TRUE;
    } 
  }
  dprint(8,(debugfile,"is_in_spool=%d\n",
	    in_spool));
  return in_spool;
}

#ifdef ANSI_C
static unsigned char *sc2uc(char *str) { return (unsigned char *)str; }
#else
#define sc2uc(x) x
#endif

static void mk_temp_mail_fn(tempfn, mbox, tempfn_size)
     char *tempfn, *mbox;
     int tempfn_size;
{
  /** create in tempfn the name of the temp file corresponding to
    mailfile mbox. 
    **/
  
  char *cp,*ptr;
  int in_spool = is_in_spool(mbox);

  dprint(8,(debugfile,"mk_temp_mail_fn: in_spool=%d, mbox=%s\n",
	    in_spool,mbox));
	       
  if (strlen(default_temp) + strlen(temp_mbox) > tempfn_size-1) {
    dprint(1,(debugfile,"mk_temp_mail_fn: Too long path!\n"));
    strfcpy(tempfn,"TEMP_MBOX", tempfn_size);
    return;
  }

  elm_sfprintf(tempfn, tempfn_size,
	       FRM("%s%s"), default_temp, temp_mbox);
  
  if((cp = rindex(mbox, '/')) != NULL) {    
    cp++;
    if (strcmp(cp, "mbox") == 0 || strcmp(cp, "mailbox") == 0 ||
	strcmp(cp, "inbox") == 0 || *cp == '.') {
      ptr = username;
    }
    else {
      ptr = cp;
    }
  } else {
    ptr = mbox;
  }

  if (strlen(tempfn) + strlen(ptr) > tempfn_size-1) {
    dprint(1,(debugfile,
	      "mk_temp_mail_fn: Too long path or mailbox!\n"));
  } else
    strfcat(tempfn, ptr, tempfn_size);

  if (!in_spool) {
    /* Assume that this is user's incoming mail area */
    if (strlen(tempfn) + strlen(username) > tempfn_size-2) {
      dprint(1,(debugfile,
		"mk_temp_mail_fn: Too long path or username!\n"));
    } else {
      strfcat(tempfn, "-", tempfn_size);
      strfcat(tempfn, username, tempfn_size);
    }
  }
  dprint(8,(debugfile,"mk_temp_mail_fn: tempfname=%s\n",tempfn));
}

static time_t now = 0;

void header_clear(h) 
     struct header_rec *h;
{
  if (0 == now) now = time(NULL);

  h->lines            = 0;
  h->status           = 0;
  h->encrypted        = 0;
  h->exit_disposition = 0;
  h->status_chgd      = 0;
  h->content_length   = -1;
  h->offset           = -1;
  h->received_time    = now;
  h->env_from[0]      = '\0';
  if (h->from)
    free_addr_items(h->from);
  h->from             = NULL;
  if (h->to)
    free_addr_items(h->to);
  h->to               = NULL;
  if (h->cc)
    free_addr_items(h->cc);
  h->cc               = NULL;
  h->messageid[0]     = '\0';
  h->time_zone[0]     = '\0';
  h->time_menu[0]     = '\0';
  h->tz_offset        = 0;
  h->subject[0]       = '\0';
  h->mailx_status[0]  = '\0';
  mime_t_clear (&(h->mime_rec));
#ifdef USE_PGP
  h->pgp              = 0;
#endif
  h->binary           = 0;
}

void header_zero(h)
     struct header_rec *h;
{
  if (0 == now) now = time(NULL);

  h->lines            = 0;
  h->status           = 0;
  h->encrypted        = 0;
  h->exit_disposition = 0;
  h->status_chgd      = 0;
  h->content_length   = -1;
  h->offset           = -1;
  h->received_time    = now;
  h->env_from[0]      = '\0';
  h->from             = NULL;
  h->to               = NULL;
  h->cc               = NULL;
  h->messageid[0]     = '\0';
  h->time_zone[0]     = '\0';
  h->time_menu[0]     = '\0';
  h->tz_offset        = 0;
  h->subject[0]       = '\0';
  h->mailx_status[0]  = '\0';
  mime_t_zero (&(h->mime_rec));
#ifdef USE_PGP
  h->pgp              = 0;
#endif
  h->binary           = 0;
}

PUBLIC int is_pre_mime_content_type (ptr,content_type)
     mime_t *ptr;
     char *content_type;
{
  int result;
  char *cptr = strpbrk(content_type,"/;()");

  dprint(12,(debugfile,"is_pre_mime_content_type(): content_type=%s\n",
	     content_type));
  
  if (!cptr || ';' == *cptr) {
    char *ptr2;
    char *tmp = content_type;
    while (whitespace(*tmp))
      tmp++;
    
    if (cptr)
      *cptr = '\0';
    
    ptr2 = strpbrk(tmp," \t");
    if (ptr2)
      *ptr2 = '\0';

    if (istrcmp(tmp,"text")!=0) {
      char buf[STRING];
      ptr -> notplain = TRUE;

      /* Put some 'intelligent' value */
      ptr ->type = MIME_TYPE_APPLICATION;
      elm_sfprintf(buf,sizeof buf,
		   FRM("X-RFC1049-%.30s"),tmp);
      strfcpy(ptr->subtype,buf,sizeof(ptr->subtype));
    } else {
      ptr -> notplain = FALSE;
      ptr ->type = MIME_TYPE_TEXT;
      strfcpy(ptr->subtype,"plain",sizeof(ptr->subtype));
    }
    result = 1;
  } else 
    result = 0;

  dprint(12,(debugfile,"is_pre_mime_content_type=%d\n",result));

  return result;
}

static int read_headers(add_new_only)
     int add_new_only;
{
	/** Reads the headers into the headers[] array and leaves the
	    file rewound for further I/O requests.   If the file being
	    read is a mail spool file (ie incoming) then it is copied to
	    a temp file and closed, to allow more mail to arrive during 
	    the elm session.  If 'add_new_only' is set, the program will copy
	    the status flags from the previous data structure to the new 
	    one if possible and only read in newly added messages.
	**/

	struct header_rec *current_header = NULL;
	char buffer[VERY_LONG_STRING], tbuffer[VERY_LONG_STRING], *c;
	long fbytes = 0L, line_bytes = 0L, content_start = -1L,
	  content_remaining = -1L, lines_start = 0L;
	register long line = 0;
	register int count = 0, another_count,
	  subj = 0, copyit = 0, in_header = FALSE,
	  forwarding_mail = FALSE, first_line = TRUE;
	int count_x, count_y = 17, err;
	int lastpercent = 0,percent;

	int content_length_found = FALSE;
	char Subject[VERY_LONG_STRING], From[VERY_LONG_STRING],
	  To[VERY_LONG_STRING], Cc[VERY_LONG_STRING];

	static int first_read = 0;
#ifdef MMDF
        int newheader = 0;
#endif /* MMDF */
	int is_content = 0;
	char content_type[VERY_LONG_STRING];

	enum what_header { IN_none,
			   IN_to_list,  
			   IN_cc_list,
			   IN_subject,
			   IN_from } in_what = IN_none;
	Subject[0] = 0;
	From[0] = 0;
	To[0] = 0;
	Cc[0] = 0;
	
	if (current_folder->folder_type == SPOOL) {
	  if (current_folder -> lock_state == ON) {
	    dprint(1, (debugfile, 
		       "read_headers: %s already locked.\n",
			current_folder->cur_folder));
	  } else
	    lock(INCOMING, current_folder);	/* ensure no mail arrives while we do this! */

	  copyit++;
	  if (add_new_only) {
	    if (fseek(current_folder -> fh_temp, 0, 2) == -1) {
	      err = errno;
	      
	      unlock(0,current_folder);	/* remove lock file! */
	      MoveCursor(elm_LINES,0);
	      Raw(OFF);
	      printf(catgets(elm_msg_cat, ElmSet, ElmCouldntSeekTempEnd,
			     "\nCouldn't fseek to end of temp mbox.\n"));
	     printf("** %s. **\n", error_description(err));
	     dprint(1, (debugfile, 
			"Error: Couldn't fseek to end of reopened temp mbox.  errno %s (%s)\n",
	         error_description(err), "read_headers"));
	     rm_temps_exit();
	    }
	  }
	}

	if (! first_read++) {
	  ClearLine(elm_LINES-1);
	  ClearLine(elm_LINES);
	  if (add_new_only)
	    PutLineX(elm_LINES, 0, CATGETS(elm_msg_cat, ElmSet, 
					   ElmReadingInMessage,
					   "Reading in %s, message: %d"),
		     current_folder->cur_folder, message_count);
	  else
	    PutLineX(elm_LINES, 0, CATGETS(elm_msg_cat, ElmSet, 
					   ElmReadingInMessage0,
					   "Reading in %s, message: 0"), 
		     current_folder-> cur_folder);
	  count_x = elm_LINES;
          count_y = 22 + strlen(current_folder->cur_folder);
	}
	else {
	  count_x = elm_LINES-2;
	  PutLineX(elm_LINES-2, 0, CATGETS(elm_msg_cat, ElmSet, 
					   ElmReadingMessage0,
					   "Reading message: 0"));
	}

	if (add_new_only) {

	  if (fseek(current_folder -> fh_folder, 
		    current_folder -> mailfile_size, SEEK_SET) == -1) {
	     err = errno;
	     MoveCursor(elm_LINES, 0);
	     Raw(OFF);
	     MCprintf(catgets(elm_msg_cat, ElmSet, ElmCouldntSeekEndFolder,
			      "\nCouldn't seek to %ld (end of folder) in %s!\n"),
		      current_folder-> mailfile_size, 
		      current_folder-> cur_folder);	
	     printf("** %s. **\n", error_description(err));
	     dprint(1, (debugfile,
			"Error: Couldn't seek to end of folder %s: (offset %ld) Errno %s (%s)\n",
			current_folder -> cur_folder, 
			current_folder -> mailfile_size, 
			error_description(err), "read_headers"));
	     emergency_exit(0);
	  }
	  count = message_count;		/* next available  */
	  fbytes = current_folder-> mailfile_size;    /* start correctly */
	}

	/** find the size of the folder then unlock the file **/

	current_folder -> mailfile_size = bytes(current_folder->cur_folder);
	unlock(0, current_folder);

	/** now let's copy it all across accordingly... **/

	while (fbytes < current_folder->mailfile_size) {

	  if ((line_bytes = mail_gets(buffer, VERY_LONG_STRING, 
				      current_folder->fh_folder)) == 0)
	    break;

	  percent = (int)(fbytes * 100.0 / current_folder->mailfile_size);
	  /* calculation with integers overflow on big folders! */
	  if (lastpercent / readdatapercentinc != percent / readdatapercentinc) {
	    PutLineX(count_x, count_y, FRM("%d (%02d%%)"), 
		     count, percent);
	    lastpercent = percent;
	  }

	  if (copyit)
	    if (fwrite(buffer, 1, line_bytes, current_folder->fh_temp) != line_bytes) {
		err = errno;
		MoveCursor(elm_LINES, 0);
		Raw(OFF);
		printf(catgets(elm_msg_cat, ElmSet, ElmWriteToTempFailed,
				"\nWrite to temp file %s failed!!\n"),
				current_folder->cur_tempfolder);
		printf("** %s. **\n", error_description(err));
		dprint(1, (debugfile, "Can't write to temp file %s!!\n",
			   current_folder->cur_tempfolder));
		rm_temps_exit();
	    }

	  /* Fix below to increment line count ONLY if we got a full line.
	   * Input lines longer than the mail_gets buffer size would
	   * get counted each time a subsequent part of them was
	   * read in. This meant that when the faulty line count was used
	   * to display the message, part of the next message
	   * was displayed at the end of the message.
	   */
	  if(buffer[line_bytes - 1] == '\n') line++;

	  if (fbytes == 0L || first_line) { 	/* first line of file... */	
	    if (current_folder->folder_type == SPOOL) {
	      if (first_word_nc(buffer, "forward to ")) {
	        set_central_message(catgets(elm_msg_cat, ElmSet, ElmMailBeingForwardTo,
			"Mail being forwarded to %s"), 
                   	(char *) (buffer + 11));
	        forwarding_mail = TRUE;
	      }
	    }

	    /** flush leading blank lines before next test... **/
	    if (line_bytes == 1) {
	      fbytes++;
	      continue;	
	    }
	    else
	      first_line = FALSE;
	      	
#ifdef MMDF
	    if (!forwarding_mail && strcmp(buffer, MSG_SEPARATOR) != 0 ) {
#else
	    if (! first_word(buffer, "From ") && !forwarding_mail) {
#endif /* MMDF */
	      MoveCursor(elm_LINES,0);
	      Raw(OFF);
	      printf(catgets(elm_msg_cat, ElmSet, ElmFolderCorrupt,
		  "\nFolder is corrupt!!  I can't read it!!\n\n"));
	      fflush(stderr);
	      dprint(1, (debugfile, 
			   "\n**** First mail header is corrupt!! ****\n"));
	      dprint(1, (debugfile, "Line is;\n\t%s\n\n", buffer));
              leave(0);
	    }
	  }

	  if (content_remaining <= 0) {
#ifdef MMDF
	    if (strcmp(buffer, MSG_SEPARATOR) == 0) {
              newheader = !newheader;
#else
	    if (first_word(buffer,"From ")) {
#endif /* MMDF */
	      /** allocate new header pointers, if needed... **/

	      if (count >= max_headers) {
		struct header_rec **new_headers;
		int new_max;

		new_max = max_headers + KLICK;
		if (max_headers == 0) {
		  new_headers = (struct header_rec **)
		    malloc(new_max * sizeof(struct header_rec *));
		}
		else {
		  new_headers = (struct header_rec **)
		    realloc((char *) headers,
			new_max * sizeof(struct header_rec *));
		}
		if (new_headers == NULL) {
	          MoveCursor(elm_LINES,0);
	          Raw(OFF);
		  printf(catgets(elm_msg_cat, ElmSet, ElmCouldntAllocMemory,
	"\n\nCouldn't allocate enough memory! Message #%d.\n\n"),
			  count);
		  leave(0);
		}
		headers = new_headers;
		while (max_headers < new_max)
		  headers[max_headers++] = NULL;
	      }
	      
	      /** allocate new header structure, if needed... **/

	      if (headers[count] == NULL) {
		struct header_rec *h;

		if ((h = (struct header_rec *)
			  malloc(sizeof(struct header_rec))) == NULL) {
	          MoveCursor(elm_LINES,0);
	          Raw(OFF);
		  printf(catgets(elm_msg_cat, ElmSet, ElmCouldntAllocMemory,
	"\n\nCouldn't allocate enough memory! Message #%d.\n\n"),
			  count);
		  leave(0);
		}
		header_zero(h);
		headers[count] = h;
	      }

	      /* Need to be called before real_from, because real_from
	       * sets time
	       */
	      header_clear(headers[count]);

	      dprint(1, (debugfile, 
		   "\n**** Calling real_from for 'From ' ****\n"));
	      if (real_from(buffer, headers[count])) {

	        dprint(1, (debugfile, 
			   "'From ' seen -- content_remaining = %ld, content_start = %ld, lines_start = %ld, fbytes = %ld\n",
			   content_remaining, content_start, lines_start, 
			   fbytes));

		current_header = headers[count];

		current_header->offset = (long) fbytes;
		current_header->index_number = count+1;
		content_length_found = FALSE;
		current_header->status = VISIBLE | NEW | UNREAD;

		Subject[0] = '\0';
		From[0]    = '\0';
		To[0] = 0;
		Cc[0] = 0;
		current_header->exit_disposition = UNSET;

		/* Set the number of lines for the _preceding_ message,
		 * but only if there was a preceding message and
		 * only if it wasn't calculated already. It would
		 * have been calculated already if we are only
		 * reading headers of new messages that have just arrived,
		 * and the preceding message was one of the old ones.
		 */
		if ((count) && (!add_new_only || count > message_count)) {
		  headers[count-1]->lines = line;

		  if (headers[count-1]->content_length < 0) {
		    if (content_start >= 0) 
		      headers[count-1]->content_length = 
			fbytes - content_start;
		    else
		      headers[count-1]->content_length = 0;
		  }
		}

		count++;
		subj = 0;
		line = 0;
		in_header = TRUE;
		content_start = -1L;

		percent = (int) (fbytes * 100.0 / 
				 current_folder->mailfile_size);
		/* calculation with integers overflow on big folders! */
		if (count % readmsginc == 0 ||
		    lastpercent / readdatapercentinc != percent / readdatapercentinc) {
		  PutLineX(count_x, count_y, FRM("%d (%02d%%)"), 
			   count, percent);
		  lastpercent = percent;
		}
#ifdef MMDF
	      } else if (newheader) {
		current_header = headers[count];

		current_header->offset = (long) fbytes;
		current_header->content_length = -1; /* not found yet */
		current_header->index_number = count+1;

		/* set default status - always 'visible'  - and
		 * if a spool file, presume 'new', otherwise
		 * 'read', for the time being until overridden
		 * by a Status: header.
		 * We presume 'read' for nonspool mailfile messages
		 * to be compatible messages stored with older versions of elm,
		 * which didn't support a Status: header.
		 */
		if(current_folder->folder_type == SPOOL)
		  current_header->status = VISIBLE | NEW | UNREAD;
		else
		  current_header->status = VISIBLE;

		Subject[0] = '\0';
		From[0] = '\0';
		To[0] = 0;
		Cc[0] = 0;
		current_header->exit_disposition = UNSET;
		
		/* Set the number of lines for the _preceding_ message,
		 * but only if there was a preceding message and
		 * only if it wasn't calculated already. It would
		 * have been calculated already if we are only
		 * reading headers of new messages that have just arrived,
		 * and the preceding message was one of the old ones.
		 */
		if (count && (!add_new_only || (count > message_count))) {
		  headers[count-1]->lines = line;
		  if (headers[count-1]->content_length < 0) {
		    /* This is second MMDF_SPERATOR between messageas, so we 
		     * need remove first MMDF_SEPARATOR between mails from 
		     * content_length
		     */
		    if (content_start >= 0) 
		      headers[count-1]->content_length = 
			fbytes - content_start-5;
		    else
		      headers[count-1]->content_length = 0;
		  }
		}

		count++;
		subj = 0;
		line = 0;
		content_start = -1L;
		content_remaining = -1L;
		content_length_found = FALSE;
		in_what    = IN_none;
		in_header = TRUE;
		if (count % readmsginc == 0)
		  PutLineX(count_x, count_y, FRM("%d"), count);
		dprint(1, (debugfile, 
			     "\n**** Added header record ****\n"));
#endif /* MMDF */
	      }
	    } else if (!forwarding_mail && count == 0) {
	      /* if this is the first "From" in file but the "From" line is
	       * not of the proper format, we've got a corrupt folder.
	       */
	      MoveCursor(elm_LINES,0);
	      Raw(OFF);
	      printf(catgets(elm_msg_cat, ElmSet, ElmFolderCorrupt,
		  "\nFolder is corrupt!!  I can't read it!!\n\n"));
	      fflush(stderr);
	      dprint(1, (debugfile, 
			   "\n**** First mail header is corrupt!! ****\n"));
	      dprint(1, (debugfile, "Line is;\n\t%s\n\n", buffer));
	      leave(0);
	    } else if (in_header == FALSE && content_length_found == TRUE && line_bytes > 1) {
		/* invalid content length, skip back to beginning of
		 * this messages text and ignore the content length
		 * field.  This requires restoring the current position
		 * in the spool file and the number of lines in the
		 * message.
		 */
	      if (content_start >= 0) {
		if (fseek(current_folder->fh_folder, content_start, 0) == -1) {
		  err = errno;
		  MoveCursor(elm_LINES, 0);
		  Raw(OFF);
		  printf(catgets(elm_msg_cat, ElmSet, 
				 ElmCouldntSeekBytesIntoFolder,
				 "\nCouldn't seek %ld bytes into folder.\n"),
			 current_folder->mailfile_size);	
		  printf("** %s. **\n", error_description(err));
		  dprint(1, (debugfile,
			     "Error: Couldn't seek folder %s: (offset %ld) Errno %s (%s)\n",
			     current_folder->cur_folder, current_folder->mailfile_size, 
			     error_description(err), "reset - read_headers"));
		  emergency_exit(0);
		}
		if (copyit) {
		  if (fseek(current_folder->fh_temp, content_start, 0) == -1) {
		    err = errno;
		    MoveCursor(elm_LINES, 0);
		    Raw(OFF);
		    printf(catgets(elm_msg_cat, ElmSet, ElmCouldntSeekBytesIntoTempFile,
		       "\nCouldn't seek %ld bytes into temp file.\n"),
			   current_folder->mailfile_size);
		    printf("** %s. **\n", error_description(err));
		    dprint(1, (debugfile,
			       "Error: Couldn't seek temp file %s: (offset %ld) Errno %s (%s)\n",
			       current_folder->cur_tempfolder, 
			       current_folder->mailfile_size, 
			       error_description(err), "reset - read_headers"));
		    emergency_exit(0);
		  }
		}
		fbytes = content_start;
		line = lines_start;
		content_length_found = FALSE;
		current_header->content_length = -1; /* mark as if not found yet */
		line_bytes = 0;
	      }
	    }
	    }

	    /* Handling of continuation lines must be done before parsing
	     * next line!   or it don't work!   
	     *
	     * Another bug is that there can happen buffer overflow....
	     *   (well perhaps I can do quick fix for that)
	     *
	     *                              - K E H <hurtta@dionysos.FMi.FI>
	     */

	    if (in_what == IN_to_list) {
	      dprint(12,(debugfile,"in_to_list; in_header=%d, buffer=%s\n",
			 in_header,buffer));
	      if (in_header && whitespace(buffer[0])) {
		if ((c = index(buffer, '\n')) != NULL)
		  *c = '\0';
		c = buffer;
		while (*c && isspace(*c)) ++c;
		strfcat(To, " ", 
			sizeof To);		  
		strfcat(To, c,
			sizeof To);
	      } else 
		in_what = IN_none;
	    } 
	    if (in_what == IN_cc_list) {
	      dprint(12,(debugfile,"in_cc_list; in_header=%d, buffer=%s\n",
			 in_header,buffer));
              if (in_header && whitespace(buffer[0])) {
		if ((c = index(buffer, '\n')) != NULL)
		  *c = '\0';
		c = buffer;
		while (*c && isspace(*c)) ++c;
		strfcat(Cc, " ",sizeof Cc);
		strfcat(Cc, c, sizeof Cc);
	      } else
		in_what = IN_none;
	    }
	    if (in_what == IN_subject) {
	      dprint(12,(debugfile,"in_subject; in_header=%d, buffer=%s\n",
			 in_header,buffer));

              if (in_header && whitespace(buffer[0])) {
		int l = strlen(buffer);
		buffer[0] = ' ';
		if (l > 1 && buffer[l-2] == '\r' && buffer[l-1] == '\n')
		  buffer[l-2] = 0;
		if (buffer[l-1] == '\n')
		  buffer[l-1] = 0;

                strfcat (Subject, buffer,sizeof(Subject));
		dprint(12,(debugfile,
			   "in_subject; l=%d => subject=%s\n",
			    l,Subject));
              }
              else 
		in_what = IN_none;
	      
	    }
	    if (in_what == IN_from) {
	      dprint(12,(debugfile,"in_from; in_header=%d, buffer=%s\n",
			 in_header,buffer));

              if (in_header && whitespace(buffer[0])) {
		int l = strlen(buffer);
		buffer[0] = ' ';
		if (l > 1 && buffer[l-2] == '\r' && buffer[l-1] == '\n')
		  buffer[l-2] = 0;
		if (buffer[l-1] == '\n')
		  buffer[l-1] = 0;

                strfcat (From, buffer,sizeof(From));
		dprint(12,(debugfile,
			   "in_from; l=%d => from=%s\n",
			    l,From));
              }
              else 
		in_what = IN_none;
	    }

	    if (is_content) {
	      dprint(12,(debugfile,"is_content; in_header=%d, buffer=%s\n",
			 in_header,buffer));
              if (in_header && whitespace(buffer[0])) {
		int l = strlen(buffer);
		buffer[0] = ' ';
		if (l > 1 && buffer[l-2] == '\r' && buffer[l-1] == '\n')
		  buffer[l-2] = 0;
		if (buffer[l-1] == '\n')
		  buffer[l-1] = 0;

                strfcat (content_type, buffer,sizeof(content_type));
		dprint(12,(debugfile,
			   "is_content=%d,l=%d => content_type=%s\n",
			    is_content,l,content_type));
              }
              else {
		char buf [STRING];
		dprint(12,(debugfile,
			   "is_content=%d => content_type=%s\n",
			   is_content,content_type));
		if (is_content == 1) {

		  if (is_pre_mime_content_type(&current_header->mime_rec,
					       content_type)) {

		    dprint(12,(debugfile,"NOT mime's content-type: %s\n",
			       content_type));
		      
		    current_header->status |= PRE_MIME_CONTENT;
		  }
                  else {
		    dprint(12,(debugfile,"MIME's content-type: %s\n",
			       content_type));

		    mime_get_content (content_type, &current_header->mime_rec);
                    if (mime_notplain(&current_header->mime_rec))
                      current_header->mime_rec.notplain = TRUE;
		    if (0 != (current_header->mime_rec.flags & MIME_SIGNED)) {
#ifdef USE_PGP
			char protocol[STRING];
			if (mime_get_param ("protocol", protocol, 
					    current_header->mime_rec.type_opts, 
					    sizeof protocol) &&
			    0 == strcasecmp(protocol,
					    "application/pgp-signature"))
			    current_header->pgp |= PGP_SIGNED_MESSAGE;
#endif
		    }
		  }
		}
		else if (is_content == 2) {
		  mime_get_disposition (content_type, 
					&current_header->mime_rec);
		}
		is_content = 0;
              }
	    }

	 if (in_header == TRUE) {

#ifdef MMDF
	    if (strcmp(buffer, MSG_SEPARATOR) == 0) {
	      /*
	       * This is disgusting, but the code below "knows" that
	       * headers all have colons in them.  However, the MMDF
	       * message separator is a header without a colon.  So,
	       * we put one there to make the rest of the logic work.
	       */
	      buffer[0] = ':';
	    } else if (first_word(buffer,"From ")) {
	      dprint(1, (debugfile, 
		   "\n**** Calling real_from for \"From_\" ****\n"));
	      real_from(buffer, current_header);
	    } else
#endif /* MMDF */
	    if (first_word_nc(buffer,">From ")) 
	      forwarded(buffer+6, current_header); /* return address */
	    else if (header_cmp(buffer,"Subject", NULL) ||
		     header_cmp(buffer,"Subj", NULL) ||
		     header_cmp(buffer,"Re", NULL)) {
	      if (! subj++) {
		int l = strlen(buffer);
		in_what = IN_subject;
		if (buffer[l-2] == '\r' && buffer[l-1] == '\n')
		  buffer[l-2] = 0;
		if (buffer[l-1] == '\n')
		  buffer[l-1] = 0;
		strfcpy (Subject, buffer,sizeof(Subject));
		remove_header_keyword(Subject);
		dprint(12,(debugfile,"in_subject; START! Subject: %s\n",
			   Subject));
	      }
	    }
	    else if (header_cmp(buffer,"From", NULL)) {
		int l = strlen(buffer);
		if (l > 1 && buffer[l-2] == '\r' && buffer[l-1] == '\n')
		  buffer[l-2] = 0;
		if (buffer[l-1] == '\n')
		  buffer[l-1] = 0;

                strfcpy (From, buffer+6,sizeof(From));
		dprint(12,(debugfile,
			   "Starting in_from; l=%d => from=%s\n",
			    l,From));
		in_what = IN_from;
	    }
	    else if (header_cmp(buffer, "Message-Id", NULL)) {
	      int l = strlen(buffer);
	      if (buffer[l-2] == '\r' && buffer[l-1] == '\n')
		buffer[l-2] = 0;
	      if (buffer[l-1] == '\n')
		buffer[l-1] = 0;

	      strfcpy(current_header->messageid,
		      buffer + 12, sizeof current_header->messageid);
	    }

	    else if (header_cmp(buffer, "Content-Length", NULL)) {
	      buffer[line_bytes - 1] = '\0';
	      current_header->content_length = atol((char *) buffer + 15);
	      /* Check if content_length is > remaining size of file */
	      if (current_header->content_length > current_folder->mailfile_size-fbytes)
		current_header->content_length = -1;
	      else
	        content_length_found = TRUE;

	    }

	    else if (header_cmp(buffer, "Expires", NULL))
	      process_expiration_date((char *) buffer + 9, 
				      &(current_header->status));
	    
	    /** when it was sent... **/

	    else if (header_cmp(buffer, "Date", NULL)) {
	      dprint(1, (debugfile, 
		      "\n**** Calling parse_arpa_date for \"Date\" ****\n"));
	      strfcpy(tbuffer, buffer, sizeof(tbuffer));
	      remove_header_keyword(tbuffer);
	      parse_arpa_date(tbuffer, current_header);
	    }

	    /** some status things about the message... **/

	    else if ((header_cmp(buffer, "Priority", NULL) ||
		     header_cmp(buffer, "Importance", "2")) &&
		   !(header_cmp(buffer, "priority", "normal") ||
		     header_cmp(buffer, "priority", "non-urgent")))
	      current_header->status |= URGENT;
	    else if (header_cmp(buffer, "Sensitivity", "2"))
	      current_header->status |= PRIVATE_MAIL;
	    else if (header_cmp(buffer, "Sensitivity", "3"))
	      current_header->status |= CONFIDENTIAL;
	    else if (header_cmp(buffer, "Content-Type", "mailform")) 
	      current_header->status |= FORM_LETTER | PRE_MIME_CONTENT;
	    else if (header_cmp(buffer, "Action", NULL))
	      current_header->status |= ACTION;
	    else if (header_cmp(buffer, "X-ELM-OSV",NULL)) {
	      char value [20];
	      if (mime_get_param("no-hdr-encoding",value,buffer+10,
				 sizeof value)) {
		int i = atoi(value);
		dprint(12,(debugfile,"-- no-hdr-encoding=%d\n",i));
		if (i) 
		  current_header->status |= NOHDRENCODING;
	      }
	    }
	    /* We should accept headers like:
	     *    MIME-Version: (MetaSend v1.7) 1.0
	     * And if version number is something other accept it but give 
	     * warning when message is viewed or replied.
	     * Perhaps in next version. 
	     */
	    else if (header_cmp(buffer, MIME_HEADER_NAME, MIME_HEADER_VERSION))
	      current_header->status |= MIME_MESSAGE;
            else if (header_cmp(buffer, MIME_HEADER_NAME, NULL))
              current_header->status |= MIME_MESSAGE|MIME_UNSUPPORTED;
	    else if (header_cmp(buffer, MIME_HEADER_CONTENTTYPE, NULL)) {
	      int l = strlen(buffer);
              is_content = 1;   /* This is quick hack -- mime headers
				 * should be decoded with mime_read_header
				 * otherwise we duplicate code ...
				 *     - K E H     <hurtta@dionysos.FMI.FI>
				 */
	      if (buffer[l-2] == '\r' && buffer[l-1] == '\n')
		buffer[l-2] = 0;
	      if (buffer[l-1] == '\n')
		buffer[l-1] = 0;
              strfcpy (content_type, buffer + 13, sizeof(content_type));
	    }
	    else if (header_cmp(buffer, "Content-Disposition", NULL)) {
	      int l = strlen(buffer);
              is_content = 2;   /* This is quick hack -- mime headers
				 * should be decoded with mime_read_header
				 * otherwise we duplicate code ...
				 *     - K E H     <hurtta@dionysos.FMI.FI>
				 */	
	      if (buffer[l-2] == '\r' && buffer[l-1] == '\n')
		buffer[l-2] = 0;
	      if (buffer[l-1] == '\n')
		buffer[l-1] = 0;
              strfcpy (content_type, buffer + 20, sizeof(content_type));
	    }
	    else if (header_cmp(buffer, MIME_HEADER_CONTENTENCOD, NULL)) {
	      int l = strlen(buffer);
	      if (buffer[l-2] == '\r' && buffer[l-1] == '\n')
		buffer[l-2] = 0;
	      if (buffer[l-1] == '\n')
		buffer[l-1] = 0;

              c = buffer + MIME_CONTENTENCOD_LEN;
              while (*c && isspace(*c)) ++c;
              current_header->mime_rec.encoding = check_encoding (c);
	      if (mime_notplain(&current_header->mime_rec))
		current_header->mime_rec.notplain = TRUE;
	    }

	    /** next let's see if it's to us or not... **/

	    else if (header_cmp(buffer, "To", NULL)) {
	      in_what = IN_to_list;

	      if ((c = index(buffer, '\n')) != NULL)
		*c = '\0';
	      c = buffer + 3;
	      while (*c && isspace(*c)) ++c;

	      if (To[0] != '\0')
		strfcat(To, ", ",sizeof To);
	      strfcat(To, c, sizeof To);
	    }
	    else if (header_cmp(buffer, "Cc", NULL)) {
	      in_what = IN_cc_list;
	      if ((c = index(buffer, '\n')) != NULL)
		*c = '\0';
	      c = buffer + 3;

	      while (*c && isspace(*c)) ++c;
	      if (Cc[0] != '\0')
		strfcat(Cc, ", ",sizeof Cc);
	      strfcat(Cc, c, sizeof Cc);
	    }
	    else if (header_cmp(buffer, "Status", NULL)) {
	      strfcpy(tbuffer, buffer, sizeof(tbuffer));
	      remove_header_keyword(tbuffer);
	      strfcpy(current_header->mailx_status, tbuffer, WLEN);

	      c = index(current_header->mailx_status, '\n');
	      if (c != NULL)
		*c = '\0';
	      c = index(current_header->mailx_status, '\r');
	      if (c != NULL)
		*c = '\0';
	      remove_possible_trailing_spaces(current_header->mailx_status);

	      /* Okay readjust the status. If there's an 'R', message
	       * is read; if there is no 'R' but there is an 'O', message
	       * is unread. In any case it isn't new because a new message
	       * wouldn't have a Status: header.
	       */
	      if (index(current_header->mailx_status, 'R') != NULL)
		current_header->status &= ~(NEW | UNREAD);
	      else if (index(current_header->mailx_status, 'O') != NULL) {
		current_header->status &= ~NEW;
		current_header->status |= UNREAD;
	      }
              if (index(current_header->mailx_status, 'r') != NULL)
                current_header->status |= REPLIED;
	    }

	    else if (buffer[0] == LINE_FEED || buffer[0] == '\0' ||
		     buffer[0] == '\r' && buffer[1] == '\n') {
	      current_header->binary = 
		(buffer[0] == '\r' && buffer[1] == '\n');
	      in_header = FALSE;	/* in body of message! */
	      content_remaining = current_header->content_length;
	      content_start = fbytes + 1;
	      if (current_header->binary)
		content_start = fbytes + 2;
	      lines_start = line;
	      current_header->mime_rec.offset = ftell (current_folder->fh_folder);
	    }
	    if (in_header == TRUE) {
	       if ((!whitespace(buffer[0])) && index(buffer, ':') == NULL) {
	        in_header = FALSE;	/* in body of message! */
	        content_remaining = current_header->content_length;
	        content_start = fbytes;
	        lines_start = line;
		current_header->mime_rec.offset = content_start;
	       }
	    }
	    /* No longer in headers */
	    if (in_header == FALSE) {
	      struct addr_item * addrs;

	      if (req_mime_hdrencoding &&
		  !(current_header->status & MIME_MESSAGE)) {
		current_header -> status |= NOHDRENCODING;
		dprint(12,(debugfile,"-- Turning on NOHDRENCODING\n"));
	      }

	      if (!req_mime_bodyencoding && 
		  !(current_header->status & PRE_MIME_CONTENT)) {
		current_header -> status |= MIME_MESSAGE;
		dprint(12,(debugfile,"-- Turning on MIME_MESSAGE\n"));
	      }

	      if (!(current_header -> status & NOHDRENCODING) &&
		  is_rfc1522(Subject)) 
		rfc1522_decode(Subject,sizeof(Subject));
	      
	      copy_sans_escape(sc2uc(current_header->subject), Subject, STRING);
		remove_possible_trailing_spaces(current_header->subject);
		dprint(12,(debugfile,"-- Decoded subject: %s\n",
			   current_header->subject));



	      dprint(1, (debugfile, 
		   "\n**** Calling parse_arpa_who for \"From\" ****\n"));

	      addrs = break_down_address(From,
					 
					 !(current_header -> status & NOHDRENCODING) &&
					 is_rfc1522(From) ?
					 rfc1522_decode_structured : decode_who_none
					 );

	      if (addrs) {
		if (current_header->from)
		  free_addr_items(current_header->from);
		current_header->from = addrs;
	      }

	      addrs = break_down_address(To,
					 !(current_header -> status & NOHDRENCODING) &&
					 is_rfc1522(To) ?
					 rfc1522_decode_structured : decode_who_none
					 );

	      if (addrs) {
		if (current_header->to)
		  free_addr_items(current_header->to);
		current_header->to = addrs;
	      }

	      addrs = break_down_address(Cc,
					 !(current_header -> status & NOHDRENCODING) &&
					 is_rfc1522(Cc) ?
					 rfc1522_decode_structured : decode_who_none
					 );

	      if (addrs) {
		if (current_header->cc)
		  free_addr_items(current_header->cc);
		current_header->cc = addrs;
	      }

	    }
	  }
	  if (in_header == FALSE) {
	    if (first_word(buffer, START_ENCODE)) {
	      current_header->encrypted = 1;
	      dprint(12,(debugfile,"-- encrypted: %s\n",buffer));

	      /* Text/plain can be converted to application/X-ELM-encode */
	      if (current_header->mime_rec.type == MIME_TYPE_TEXT && 
		  (istrcmp(current_header->mime_rec.subtype,"plain")==0)) {
		  current_header->mime_rec.type = MIME_TYPE_APPLICATION;
		  strfcpy(current_header->mime_rec.subtype, "X-ELM-encode",
			  sizeof current_header->mime_rec.subtype);
		  /* Keep current_header->mime_rec.type_opts ! */
	      }
	      dprint(12,(debugfile,"-- encrypted, %d/%s; opts=%s\n",
			 current_header->mime_rec.type,
			 current_header->mime_rec.subtype,
			 NONULL(current_header->mime_rec.type_opts)));
	    }
#ifdef USE_PGP
	    if (strncmp(buffer, "-----BEGIN PGP", 14) == 0) {
	      if (strncmp(buffer + 15, "PUBLIC", 6) == 0) {
		current_header->pgp |= PGP_PUBLIC_KEY;
		dprint(12,(debugfile,"-- PGP PUBLIC KEY: %s\n",buffer));
	      } else {
		char pgpbuffer[STRING];

		/* Text/plain can be converted to application/pgp.  There will
		 * a possible loss of surrounding text, but there is no way
		 * to get around this without having the sender use the proper
		 * MIME type.
		 */
		if (current_header->mime_rec.type == MIME_TYPE_TEXT && 
		    istrcmp(current_header->mime_rec.subtype,"plain")==0) {
		  current_header->mime_rec.type = MIME_TYPE_APPLICATION;
		  strfcpy(current_header->mime_rec.subtype, "pgp",
			  sizeof current_header->mime_rec.subtype);
		  /* Keep current_header->mime_rec.type_opts ! */
		}
		
		if (strncmp(buffer + 15, "SIG", 3) == 0) {
		  current_header->pgp |= PGP_SIGNED_MESSAGE;
		  dprint(12,(debugfile,"-- PGP signed: %s\n",buffer));
		  
		  if (!mime_get_param("x-action",
				      pgpbuffer,
				      current_header->mime_rec.type_opts,
				      sizeof(pgpbuffer))) {
		      add_parameter_t(&(current_header->mime_rec),
				      "x-action", "sign",
				      FALSE);
		  }
		  dprint(12,(debugfile,"-- PGP signed, %d/%s; opts=%s\n",
			     current_header->mime_rec.type,
			     current_header->mime_rec.subtype,
			     NONULL(current_header->mime_rec.type_opts)));
		}
		else {
		  current_header->pgp |= PGP_MESSAGE;
		  dprint(12,(debugfile,"-- PGP message: %s\n",buffer));
		  
		  if (!mime_get_param("x-action",pgpbuffer,
				      current_header->mime_rec.type_opts,
				      sizeof(pgpbuffer))) {		    
		      add_parameter_t(&(current_header->mime_rec),
				      "x-action", "encrypt",FALSE);
		  }
		  dprint(12,(debugfile,"-- PGP message, %d/%s; opts=%s\n",
			     current_header->mime_rec.type,
			     current_header->mime_rec.subtype,
			     NONULL(current_header->mime_rec.type_opts)));
		}
              }
	    }
#endif /* USE_PGP */
	  }
	  fbytes += (long) line_bytes;
	  
	  content_remaining -= (long) line_bytes;
	}

	if (count) {
	  headers[count-1]->lines = line + 1;
	  if (headers[count-1]->content_length < 0) {
	    if (content_start >= 0L)
	      headers[count-1]->content_length = fbytes - content_start;
	    else
	      headers[count-1]->content_length = 0;
	  }
	}

	if (current_folder->folder_type == SPOOL) {
	  unlock(0, current_folder);	/* remove lock file! */
	  
	  if ((ferror(current_folder->fh_temp)) || 
	      (fflush(current_folder->fh_temp) == EOF)) {
	    err = errno;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFlushOnTempFailed,
			      "Flush on temp file %s failed: %s"), 
		      current_folder -> cur_tempfolder,
		      error_description(err));
	  dprint(1, (debugfile, "Can't flush on temp file %s!!\n",
		     current_folder -> cur_tempfolder));
	  rm_temps_exit();
	  }

	  /* sanity check on append - is resulting temp file longer??? */
	  if ( bytes(current_folder-> cur_tempfolder) != 
	       current_folder-> mailfile_size) {
	    MoveCursor(elm_LINES, 0);
	    Raw(OFF);
	    printf(catgets(elm_msg_cat, ElmSet, ElmLengthNESpool,
			   "\nnewmbox - length of mbox. != spool mailbox length!!\n"));
	    dprint(1, (debugfile, "newmbox - mbox. != spool mail length"));
	    rm_temps_exit();
	  }
	  
	  rewind(current_folder->fh_temp);
	  current_folder->use_temp = 1;
	} else {
          rewind(current_folder->fh_folder);
	  current_folder->use_temp = 0;
	}

	/* Sort folder *before* we establish the current message, so that
	 * the current message is based on the post-sort order.
	 * Note that we have to set the global variable message_count
	 * before the sort for the sort to correctly keep the correct
	 * current message if we are only adding new messages here. */

	message_count = count;
	sort_mailbox(count, 1);

	/* Now lets figure what the current message should be.
	 * If we are only reading in newly added messages from a mailfile
	 * that already had some messages, current should remain the same.
	 * If we have a folder of no messages, current should be zero.
	 * Otherwise, if we have point_to_new on then the current message
	 * is the first message of status NEW if there is one.
	 * If we don't have point_to_new on or if there are no messages of
	 * of status NEW, then the current message is the first message.
	 */
	if(!(add_new_only && current != 0)) {
	  if(count == 0)
	    current = 0;
	  else {
	    current = 1;
	    if (point_to_new) {
	      for(another_count = 0; another_count < count; another_count++) {
		if(ison(headers[another_count]->status, NEW)) {
		  current = another_count+1;
		  goto found_new;
		}
	      }
	      for(another_count = 0; another_count < count; another_count++) {
		if(ison(headers[another_count]->status, UNREAD)) {
		  current = another_count+1;
		  goto found_new;
		}
	      }
	      switch (sortby) {
		case SENT_DATE:
		case RECEIVED_DATE:
		case MAILBOX_ORDER:
		  current = count;
	      }
	      found_new: ;
	    }
	  }
	}
        get_page(current);
	return(count);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
