/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998, Double Precision Inc.                                    */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#ifndef	rfc822_h
#define	rfc822_h

static const char rfc822_h_rcsid[]="$Id: rfc822.h 1.1 1998/04/17 00:08:53 mrsam Exp $";

/*
** The text string we want to parse is first tokenized into an array of
** struct rfc822token records.  'ptr' points into the original text
** string, and 'len' has how many characters from 'ptr' belongs to this
** token.
*/

struct rfc822token {
	int token;
/*
  Values for token:

  '(' - comment
  '"' - quoted string
  '<', '>', '@', ',', ';', ':', '.', '[', ']', '%', '!' - RFC atoms.
  0   - atom
*/

	const char *ptr;	/* Pointer to value for the token. */
	int len;		/* Length of token value */
} ;

/*
** After the struct rfc822token array is built, it is used to create
** the rfc822addr array, which is the array of addresses (plus
** syntactical fluff) extracted from those text strings.  Each rfc822addr
** record has several possible interpretation:
**
** tokens is NULL - syntactical fluff, look in name/nname for tokens
**                  representing the syntactical fluff ( which is semicolons
**                  and  list name:
**
** tokens is not NULL - actual address.  The tokens representing the actual
**                  address is in tokens/ntokens.  If there are comments in
**                  the address that are possible "real name" for the address
**                  they are saved in name/nname (name may be null if there
**                  is none).
**                  If nname is 1, and name points to a comment token,
**                  the address was specified in old-style format.  Otherwise
**                  the address was specified in new-style route-addr format.
**
** The tokens and name pointers are set to point to the original rfc822token
** array.
*/

struct rfc822addr {
	struct rfc822token *tokens;
	int ntokens;
	struct rfc822token *name;
	int nname;
} ;

/***************************************************************************
**
** Main rfc822 structure.
**
***************************************************************************/

struct rfc822 {
	struct rfc822token *tokens;
	int	ntokens;
	struct rfc822addr *addrs;
	int	naddrs;
} ;

struct rfc822 *rfc822_alloc(const char *p,
	void (*err_func)(const char *, int));	/* Parse addresses */
void rfc822_free(struct rfc822 *);		/* Free rfc822 structure */

void rfc822_deladdr(struct rfc822 *, int);

/* rfc822_print "unparses" the rfc822 structure.  Each rfc822addr is "printed"
   (via the attached function).  NOTE: instead of separating addresses by
   commas, the print_separator function is called (the supplied argument
   will be either a comma, or a semicolon).
*/

void rfc822_print(struct rfc822 *,
	void (*print_func)(char),
	void (*print_separator)(const char *));

/* Another unparser, except that only the raw addresses are extracted,
   and each address is followed by a newline character */

void rfc822_addrlist(const struct rfc822 *, void (*print_func)(char));

/* Now, just the comments.  If comments not given, the address. */
void rfc822_namelist(const struct rfc822 *, void (*print_func)(char));

/* Unparse an individual name/addr from a list of addresses.  If the given
   index points to some syntactical fluff, this is a noop */

void rfc822_prname(const struct rfc822 *, int, void (*)(char));
void rfc822_praddr(const struct rfc822 *, int, void (*)(char));

#endif
