#
# IST / INESC
# Authors: Antonio Rendas and Vasco Amaral
# 
# This script is a fine example of the power of using tcl/tk as a integration
# language in adition to our extension commands for Abacus cosntruction
# and manipulation.
#
# This was used as a presentation of our final graduation project "Abacus"
# in our University "Instituto Superior Tecnico" in Lisbon-Portugal(1997/1998)
#
# This might be also instructive about what we have made along this project 
# so far.
#


# 
# Some important vars Initialization
#

set presentation(height) 650
set presentation(width) 800
set presentation(titleheight) 6
set presentation(titlestyle) {lbold blue}
set presentation(slidejump) 1

#
# Defining text styles to be displayed
#

proc TextStyles {t} {

    #bold
    $t tag configure lbold -font {times 32 bold} 
    $t tag configure mbold -font {times 24 bold} 
    $t tag configure sbold -font {times 18 bold} 

    #italic
    $t tag configure litalic -font {times 32 italic} 
    $t tag configure mitalic -font {times 24 italic} 
    $t tag configure sitalic -font {times 18 italic} 

    #underline
    $t tag configure underline -underline true 

    #normal
    $t tag configure large -font {times 32} 
    $t tag configure medium -font {times 24} 
    $t tag configure small -font {times 18} 

    $t tag configure l -font {times 32} 
    $t tag configure m -font {times 24} 
    $t tag configure s -font {times 18} 

    #alignment
    $t tag configure left -justify left
    $t tag configure right -justify right
    $t tag configure center -justify center

    #colors
    $t tag configure red -foreground red 
    $t tag configure green -foreground green 
    $t tag configure blue -foreground blue 


}
    
#
# Displaying the slide
#

proc Presentation {{name "present"} {slide "text"} \
		       {showinfo {{"TOPICS:" "\t->TOPIC 1"} {"\t->TOPIC 2" center}}} \
		       {showtitle "TITLE"} {showsubtitle ""}} {

    global presentation
    
    set w .slideshow.slides.$name

    frame .slideshow.slides -height $presentation(height) 
    frame $w 

    #pack .slideshow.slides -side bottom -fill y -expand y
    pack $w -expand yes -fill both


    pack propagate .slideshow.slides false

    pack .slideshow.slides -side bottom -expand yes -fill both


    frame $w.ptitle
    frame $w.information 

    set t $w.ptitle; set i $w.information;

#
# Title text
#

    text $t.title \
        -relief sunken -borderwidth 2 \
	-exportselection yes -wrap word -cursor left_ptr \
	-height $presentation(titleheight) -background Grey

    $t.title tag configure info -lmargin2 0.5i 

    pack $t.title -in $w.ptitle -side right -fill x -expand yes  

    # Major title
    $t.title insert end $showtitle [lappend presentation(titlestyle) Big-Title]

    $t.title insert end "\n" 

    # Minor title
    $t.title insert end $showsubtitle {mitalic Big-Title}

    $t.title tag configure Big-Title -justify center
    
    TextStyles $t.title

    #
    # Textual Information
    #
    
    text $i.information \
	-tabs { 3c left } \
	-exportselection yes -wrap word -cursor left_ptr \
	-background Grey
    
    $t.title tag configure info -lmargin2 0.5i 
    
    pack $i.information -in $w.information -side right -fill both -expand yes   
    
    if {[regexp "text" $slide]} {
	
	#
	# Information
	#

	set line 0

	foreach j $showinfo {
	    set line [expr $line+1]
	    $i.information insert end "\n[lindex $j 0]" [lrange $j 0 [llength $j]]

	    TextStyles $i.information
	}
	
    } elseif {[regexp "picture" $slide]} {
	
	#
	# Pictures Informations
	#
	
	set presentation(image) [image create photo \
				      -file $showinfo -palette 5/5/5]

	$i.information insert end "\n " {center}
				  
	$i.information image create insert -image $presentation(image) -align center

	TextStyles $i.information

    } 

    #
    # Final pack
    #
    pack $w.ptitle -fill x
    pack $w.information -in $w -fill both -expand yes
    
}


toplevel .slideshow -class abacus

wm iconname .slideshow "Presentation"

set present 0
set demo "Not Loaded"

#
# Presentation control buttons
#


frame .slideshow.control -width $presentation(width) -height 30

label .slideshow.control.label -textvariable present -width 10 -bg white

label .slideshow.control.demo -textvariable demo -width 10 -bg red
label .slideshow.control.demotext -text "Demo"

label .slideshow.control.labeltext -text "Slide number:"

label .slideshow.control.jumptext -text "Jump Step:"

label .slideshow.control.jump -textvariable presentation(slidejump) -width 5 -bg white


button .slideshow.control.next -text Next \
    -command { 
	if { [llength $slides]>[expr $present+$presentation(slidejump)] } {
	    destroy .slideshow.slides;
	    set present [expr $present +$presentation(slidejump)];
	    eval [lindex $slides $present]}
    }

button .slideshow.control.previous -text Previous \
    -command {
	if { [expr $present-$presentation(slidejump)]>=0 } {
	    destroy .slideshow.slides;
	    set present [expr $present -$presentation(slidejump)];
	    eval [lindex $slides $present]}
    }

button .slideshow.control.quit -text "Quit Presentation" \
    -command { destroy .slideshow }


pack .slideshow.control -side top
pack .slideshow.control.quit -side right
pack .slideshow.control.label -side right -ipadx 10
pack .slideshow.control.labeltext -side right -ipadx 10

pack .slideshow.control.previous -side left 
pack .slideshow.control.next -side left

pack .slideshow.control.jumptext -side left -ipadx 10
pack .slideshow.control.jump -side left -ipadx 10

pack .slideshow.control.demo -side right -ipadx 10
pack .slideshow.control.demotext -side right -ipadx 10

pack propagate .slideshow.control false

source slides.tcl

eval [lindex $slides 0]


#
# We don't want to mess with Abacus during presentation, thus we 
# grab .slideshow window
#

grab .slideshow.control
    

#
# some key bindings so that we wont have to use mouse in our presentation
#

bind .slideshow <Key-Return> {.slideshow.control.next invoke}

bind .slideshow <Key-Escape> { switch -exact $presentation(slidejump) {
    1 {set presentation(slidejump) 5}
    5 {set presentation(slidejump) 10}
    10 {set presentation(slidejump) 1}}}

bind .slideshow <Key-space> {.slideshow.control.previous invoke}

