/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * math_utils.h
 */

#ifndef MATH_UTILS_h
#define MATH_UTILS_h

#include <manifold.h>

/* blas.h */
double L2_norm(int dim, double *v);
void print_vector(int n, double *v);
double dot(int dim, double *u, double *v);
double L2_norm(int dim, double *v);
double L2_norm_sqr(int dim, double *v);
double euclid_dist(int dim, double *u, double *v);
double euclid_dist_sqr(int dim, double *u, double *v);
double *normalize(int dim, double *v);
double *proj_vector(int dim, double *u, double *v, double *w);
double *orthog_vector(int dim, double * u, double *v, double *w);
double cos_between(int dim, double *u, double *v);
int same_side(int dim, double *c, double *v, double *u);


/* vector and matrix utils */
double *dvector(int nl, int nh);
void free_dvector(double *v, int nl, int nh);
int *ivector(int nl, int nh);
void free_ivector(int *v, int nl, int nh);
double **dmatrix(int nrl, int nrh, int ncl, int nch);
void free_dmatrix(double **m, int nrl, int nrh, int ncl, int nch);

/* jacobian.c */
int dfdx( double **matrix, int n, double *h, double *state, double *parameters,
     int k, Manifold *manifold, int map_flag,
     int (*ds_func)(double [], double [], double []),
     int (*ds_dfunc)(double **, double [], double []),
     int mode, double *work);
int dfdt( double *vector, int n, double h, double *state, double *parameters,
     int k, Manifold *manifold, int map_flag,
     int (*ds_func)(double [], double [], double[]),
     int (*ds_dfunc)(double [], double[] , double []),
     int mode, double *work);
int dfdp(double **matrix, int n, int m, double *h, double *state, double *parameters,
     int k, Manifold *manifold, int map_flag,
     int (*ds_func)(double [], double[], double[]),
     int (*ds_dfunc)(double **, double [], double []),
     int mode, double *work);



/* vector.c */
void dcopy(int n, double *dx, int incx, double *dy, int incy);
double ddot(int n, double *dx, int incx, double *dy, int incy);
void daxpy(int n, double da, double *dx, int incx, double *dy, int incy);
void dswap (int n, double *dx, int incx, double *dy, int incy);
void dscal(int n, double da, double *dx, int incx);
int idamax(int n, double *dx, int incx);
double sup_norm(double *v, int n);

/* random.c */
int rnd_vector(int n, double *x, double *min, double *max);
 
/* ludcmp.c */
int ludcmp(double **a, int n, int *indx, double *d);
 
/* lubksb.c */
int lubksb(double **a, int n, int indx[], double b[]);
 
#endif
/* !MATH_UTILS_h */













