/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef DISCGRPDEF
#define DISCGRPDEF

#include "bbox.h"
#include "dgflag.h"
#include "create.h"
#include "appearance.h"
#include "pick.h"
#include "streampool.h"

#ifndef NULL
#define NULL 0
#endif

#ifndef	FALSE
#define	FALSE 0
#endif

#define DISCGRPMAGIC	GeomMagic('d',1)

typedef struct DiscGrp DiscGrp ;

extern DiscGrp	*DiscGrpPick( DiscGrp *, Pick *, Appearance *, Transform );
extern GeomClass *DiscGrpMethods( void );
extern char	*DiscGrpName( void );
/*
extern DiscGrp	*DiscGrpFLoad( FILE *, char * );
extern DiscGrp	*DiscGrpLoad( char * );
*/
extern Geom  *DiscGrpImport (Pool * );
extern DiscGrp	*DiscGrpSave( DiscGrp *, char * );
extern DiscGrp	*DiscGrpFSave( DiscGrp *, FILE *, char * );
extern BBox	*DiscGrpBound( DiscGrp *, Transform );
extern DiscGrp	*DiscGrpDraw( DiscGrp * );
/*
extern DiscGrpElList *DiscGrpElListCreate(DiscGrpElList *, ...);
extern DiscGrp	*DiscGrpEvert( DiscGrp * );
extern DiscGrp     *DiscGrpTransform( DiscGrp *, Transform );
extern DiscGrp     *DiscGrpTransformTo( DiscGrp *, Transform );
*/

/* tokens used by the create routines, not duplicated in create.h */
/* we'll use the '900' region: this ought to be registered somewhere */
/* DGELC == DiscGrpElListCreate
   DGC == DiscGrpCreate
*/
#define 	DGCR_ATTRIBUTE	900	/* int : attributes in both DGC and DGELC */
#define 	DGCR_ATTRIBUTELIST 901	/* int * : list of attributes in DGELC */
#define 	DGCR_WORD	902	/* char (*)[DG_WORDLENGTH] : used by DiscGrpElListCreate */
#define		DGCR_ELEM	903	/* DiscGrpEl * : used in DGELC  */
					/* note that CR_ELEM is also used here */
#define		DGCR_CPOINT	905	/* HPoint3 * :base  point of dirichlet domain: */
#define		DGCR_CAMGEOM	906	/* Geom * :geometry used to represent the observer*/
#define		DGCR_DDGEOM	907	/* Geom * :geometry for Dirichlet domain */
#define 	DGCR_GENS	908	/* DiscGrpElList * : generators */
#define 	DGCR_BIGLIST	910	/* DiscGrpElList * : general list */
#define 	DGCR_ENUMDEPTH	911	/* int : depth to compute wordlist */
#define 	DGCR_ENUMDIST	912	/* float : maximum distance of tiles */
#define 	DGCR_SCALE	913	/* float : scaling factor for dirdom */
#define 	DGCR_FLAG	914	/* the flag field of the DiscGrp */
#define 	DGCR_NAME	915	/* the flag field of the DiscGrp */
#define 	DGCR_COMMENT	916	/* the flag field of the DiscGrp */

#endif /*DISCGRPDEF*/
