/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/*
 * Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Nathaniel Thurston
 */

#ifndef COMMENTDEFS
#define COMMENTDEFS

/*
 * Private definitions for Comments
 */

#include "bbox.h"

typedef struct Comment Comment;

extern GeomClass *CommentClass;		/* Public read-only; valid only
					 * after first call to CommentMethods()
					 */

extern GeomClass *CommentMethods( void );

extern Geom *CommentImport( Pool *p );
extern int   CommentExport( Comment *, Pool * );
extern Comment *CommentLoad( char * );
extern Comment *CommentFLoad( FILE *, char *name );
extern Comment *CommentSave( Comment *, char * );
extern Comment *CommentFSave( Comment *, FILE *, char * );

#endif /*COMMENTDEFS*/
