typedef	double  point4[4];
typedef	double  plane4[4];
typedef	double  matrix4[4][4];

matvecmul4(m,v1,v2)
matrix4 m;
point4 v1,v2;
{
    register int i,j,k;
    double tmp[4], *tv1, *tv2;
 
    tv1 = (double *) v1; 
    tv2 = (double *) v2;
    for (i=0; i<4; ++i)
	for (tmp[i]=0, j = 0; j<4; ++j)
	    tmp[i] += m[i][j] * tv1[j];
    for (i=0; i<4; ++i)
	tv2[i] = tmp[i];
}

vecmatmul4(v1,m,v2)
matrix4 m;
point4 v1,v2;
{
    register int i,j,k;
    double tmp[4], *tv1, *tv2;
 
    tv1 = (double *) v1; 
    tv2 = (double *) v2;
    for (i=0; i<4; ++i)
	for (tmp[i]=0, j = 0; j<4; ++j)
	    tmp[i] += m[j][i] * tv1[j];
    for (i=0; i<4; ++i)
	tv2[i] = tmp[i];
}

matmatmul4 (mat1, mat2, mat3)
matrix4 mat1, mat2, mat3;

{
    register int i, j, k;
    double tmp[4];

    for (i = 0; i < 4; i++) {
	for (j = 0; j < 4; j++) {
	    tmp[j] = 0.0;
	    for (k = 0; k < 4; k++) {
		tmp[j] += mat1[i][k] * mat2[k][j];
	    }
	    mat3[i][j] = tmp[j];
	}
    }
}
